/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.utils;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManager.class);

    public static <R> R executeWithTransaction(SessionFactory sessionFactory, DatabaseOperation<R> operation, String errorMessage, boolean readOnly) {
        try (Session session = sessionFactory.openSession();){
            R r;
            if (readOnly) {
                session.setDefaultReadOnly(true);
            }
            Transaction tx = session.beginTransaction();
            try {
                R result = operation.execute(session);
                tx.commit();
                r = result;
            }
            catch (Exception e) {
                tx.rollback();
                LOGGER.error(errorMessage, (Throwable)e);
                if (e instanceof BaseException) {
                    throw (BaseException)e;
                }
                throw new BaseException(ErrorCode.INTERNAL, errorMessage + ": " + e.getMessage());
            }
            return r;
        }
    }

    @FunctionalInterface
    public static interface DatabaseOperation<R> {
        public R execute(Session var1) throws Exception;
    }
}

