/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.utils;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.model.TemporaryCredentials;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriUtils.class);

    private UriUtils() {
    }

    public static String createStorageLocationPath(String uri) {
        return UriUtils.updateDirectoryFromUri(uri, Operation.CREATE, Optional.empty()).toString();
    }

    public static String deleteStorageLocationPath(String uri) {
        return UriUtils.updateDirectoryFromUri(uri, Operation.DELETE, Optional.empty()).toString();
    }

    private static URI updateDirectoryFromUri(String uri, Operation op, Optional<TemporaryCredentials> credentials) {
        URI parsedUri = URI.create(uri);
        UriUtils.validateURI(parsedUri);
        try {
            if (parsedUri.getScheme().equals("file")) {
                return UriUtils.updateLocalDirectory(parsedUri, op);
            }
            if (parsedUri.getScheme().equals("s3")) {
                return parsedUri;
            }
            if (parsedUri.getScheme().equals("gs")) {
                return parsedUri;
            }
            if (parsedUri.getScheme().equals("abfs") || parsedUri.getScheme().equals("abfss")) {
                return parsedUri;
            }
        }
        catch (Exception e) {
            throw new BaseException(ErrorCode.INTERNAL, "Error attempting to " + op.name() + " URI " + parsedUri.toString() + ": " + e.getMessage());
        }
        throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Unknown scheme detected: " + parsedUri.getScheme());
    }

    public static boolean isValidURI(String uri) {
        try {
            URI testURI = new URI(uri);
            return testURI.getScheme() != null && testURI.getPath() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static URI updateLocalDirectory(URI parsedUri, Operation op) throws IOException {
        block14: {
            Path dirPath = Paths.get(parsedUri);
            if (op == Operation.CREATE) {
                if (Files.exists(dirPath, new LinkOption[0])) {
                    throw new BaseException(ErrorCode.ALREADY_EXISTS, "Directory already exists: " + String.valueOf(dirPath));
                }
                try {
                    Files.createDirectories(dirPath, new FileAttribute[0]);
                    LOGGER.debug("Directory created successfully: {}", (Object)dirPath);
                }
                catch (Exception e) {
                    throw new BaseException(ErrorCode.INTERNAL, "Failed to create directory: " + String.valueOf(dirPath), e);
                }
            }
            if (op == Operation.DELETE) {
                if (Files.exists(dirPath, new LinkOption[0])) {
                    try (Stream<Path> walk = Files.walk(dirPath, FileVisitOption.FOLLOW_LINKS);){
                        walk.sorted(Comparator.reverseOrder()).forEach(path -> {
                            try {
                                Files.delete(path);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to delete " + String.valueOf(path), e);
                            }
                        });
                        break block14;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to delete " + String.valueOf(dirPath), e);
                    }
                }
                throw new IOException("Directory does not exist: " + String.valueOf(dirPath));
            }
        }
        return parsedUri;
    }

    private static void validateURI(URI uri) {
        if (uri.getScheme() == null) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Invalid path: " + uri.getPath());
        }
        URI normalized = uri.normalize();
        if (!normalized.getPath().startsWith(uri.getPath())) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Normalization failed: " + uri.getPath());
        }
    }

    private static enum Operation {
        CREATE,
        DELETE;

    }
}

