/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.security;

import com.auth0.jwt.algorithms.Algorithm;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    private Path rsa512PublicKey;
    private Path rsa512PrivateKey;
    private Path keyId;

    public SecurityConfiguration(Path configurationFolder) {
        this.rsa512PublicKey = configurationFolder.resolve("public_key.der");
        this.rsa512PrivateKey = configurationFolder.resolve("private_key.der");
        this.keyId = configurationFolder.resolve("key_id.txt");
        this.initializeIfMissing();
    }

    public void initializeIfMissing() {
        if (Files.notExists(this.rsa512PublicKey, new LinkOption[0]) || Files.notExists(this.rsa512PrivateKey, new LinkOption[0]) || Files.notExists(this.keyId, new LinkOption[0])) {
            log.info("Initializing security configuration.");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Path parentDirectory = this.rsa512PublicKey.getParent();
            if (parentDirectory != null && !Files.exists(parentDirectory, new LinkOption[0])) {
                Files.createDirectories(parentDirectory, new FileAttribute[0]);
            }
            Files.write(this.rsa512PublicKey, keyPair.getPublic().getEncoded(), StandardOpenOption.CREATE);
            Files.write(this.rsa512PrivateKey, keyPair.getPrivate().getEncoded(), StandardOpenOption.CREATE);
            byte[] keyIdBytes = new byte[32];
            new SecureRandom().nextBytes(keyIdBytes);
            Files.writeString(this.keyId, (CharSequence)Hex.encodeHexString((byte[])keyIdBytes), StandardOpenOption.CREATE);
        }
    }

    public Algorithm algorithmRSA() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return Algorithm.RSA512((RSAPublicKey)this.rsaPublicKey(), (RSAPrivateKey)this.rsaPrivateKey());
    }

    public RSAPublicKey rsaPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (Files.notExists(this.rsa512PublicKey, new LinkOption[0])) {
            log.info("No JWT public signing key present.");
            return null;
        }
        byte[] keyBytes = Files.readAllBytes(this.rsa512PublicKey);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)kf.generatePublic(spec);
    }

    public RSAPrivateKey rsaPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (Files.notExists(this.rsa512PrivateKey, new LinkOption[0])) {
            log.info("No JWT private signing key present.");
            return null;
        }
        byte[] keyBytes = Files.readAllBytes(this.rsa512PrivateKey);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)kf.generatePrivate(spec);
    }

    public String getKeyId() throws IOException {
        return Files.readString(this.keyId).trim();
    }
}

