/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.server.security.JwtClaim;
import io.unitycatalog.server.security.JwtTokenType;
import io.unitycatalog.server.security.SecurityConfiguration;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private final Path certsFile;
    private final Path serviceTokenFile;
    private final RSAPublicKey rsaPublicKey;
    private final RSAPrivateKey rsaPrivateKey;
    private final Algorithm algorithm;
    private final String serviceToken;
    private final String keyId;
    private final String serviceName;
    private final String localIssuer;

    public SecurityContext(Path configurationFolder, SecurityConfiguration securityConfiguration, String serviceName, String localIssuer) {
        this.serviceName = serviceName;
        this.localIssuer = localIssuer;
        this.certsFile = configurationFolder.resolve("certs.json");
        this.serviceTokenFile = configurationFolder.resolve("token.txt");
        this.rsaPublicKey = securityConfiguration.rsaPublicKey();
        this.rsaPrivateKey = securityConfiguration.rsaPrivateKey();
        this.algorithm = securityConfiguration.algorithmRSA();
        this.keyId = securityConfiguration.getKeyId();
        this.serviceToken = this.createServiceToken();
        this.createInternalCertsFile();
        this.createServiceTokenFile();
        LOGGER.info("--- Internal Certs Configuration --");
        LOGGER.info(this.getInternalCertsFile());
    }

    public String createAccessToken(DecodedJWT decodedJWT) {
        String subject = decodedJWT.getClaims().getOrDefault(JwtClaim.EMAIL.key(), decodedJWT.getClaim(JwtClaim.SUBJECT.key())).asString();
        return JWT.create().withSubject(this.serviceName).withIssuer(this.localIssuer).withIssuedAt(new Date()).withKeyId(this.keyId).withJWTId(UUID.randomUUID().toString()).withClaim(JwtClaim.TOKEN_TYPE.key(), JwtTokenType.ACCESS.name()).withClaim(JwtClaim.SUBJECT.key(), subject).sign(this.algorithm);
    }

    public String createServiceToken() {
        return JWT.create().withSubject(this.serviceName).withIssuer(this.localIssuer).withIssuedAt(new Date()).withKeyId(this.keyId).withJWTId(UUID.randomUUID().toString()).withClaim(JwtClaim.TOKEN_TYPE.key(), JwtTokenType.SERVICE.name()).withClaim(JwtClaim.SUBJECT.key(), "admin").sign(this.algorithm);
    }

    public void createInternalCertsFile() {
        LinkedHashMap<String, String> key = new LinkedHashMap<String, String>();
        key.put("kid", this.keyId);
        key.put("use", "sig");
        key.put("kty", this.rsaPublicKey.getAlgorithm());
        key.put("alg", this.algorithm.getName());
        key.put("e", Base64.getUrlEncoder().encodeToString(this.rsaPublicKey.getPublicExponent().toByteArray()));
        key.put("n", Base64.getUrlEncoder().encodeToString(this.rsaPublicKey.getModulus().toByteArray()));
        ArrayList<LinkedHashMap<String, String>> keyList = new ArrayList<LinkedHashMap<String, String>>();
        keyList.add(key);
        HashMap<String, ArrayList<LinkedHashMap<String, String>>> keyMap = new HashMap<String, ArrayList<LinkedHashMap<String, String>>>();
        keyMap.put("keys", keyList);
        Files.writeString(this.certsFile, (CharSequence)mapper.writerWithDefaultPrettyPrinter().writeValueAsString(keyMap), new OpenOption[0]);
    }

    public String getInternalCertsFile() {
        return Files.readString(this.certsFile);
    }

    public void createServiceTokenFile() {
        Files.writeString(this.serviceTokenFile, (CharSequence)this.serviceToken, new OpenOption[0]);
    }

    public Path getCertsFile() {
        return this.certsFile;
    }

    public RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public RSAPrivateKey getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getServiceToken() {
        return this.serviceToken;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getLocalIssuer() {
        return this.localIssuer;
    }

    public static interface Issuers {
        public static final String INTERNAL = "internal";
    }
}

