/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.AttributeKey;
import io.unitycatalog.control.model.User;
import io.unitycatalog.server.exception.AuthorizationException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.security.SecurityContext;
import io.unitycatalog.server.utils.JwksOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDecorator
implements DecoratingHttpServiceFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthDecorator.class);
    private final UserRepository userRepository;
    public static final String UC_TOKEN_KEY = "UC_TOKEN";
    private static final String BEARER_PREFIX = "Bearer ";
    public static final AttributeKey<DecodedJWT> DECODED_JWT_ATTR = AttributeKey.valueOf(DecodedJWT.class, (String)"DECODED_JWT_ATTR");
    private final JwksOperations jwksOperations;

    public AuthDecorator(SecurityContext securityContext, Repositories repositories) {
        this.jwksOperations = new JwksOperations(securityContext);
        this.userRepository = repositories.getUserRepository();
    }

    public HttpResponse serve(HttpService delegate, ServiceRequestContext ctx, HttpRequest req) throws Exception {
        User user;
        LOGGER.debug("AuthDecorator checking {}", (Object)req.path());
        String authorizationHeader = req.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        String authorizationCookie = req.headers().cookies().stream().filter(c -> c.name().equals(UC_TOKEN_KEY)).map(Cookie::value).findFirst().orElse(null);
        DecodedJWT decodedJWT = JWT.decode((String)this.getAccessTokenFromCookieOrAuthHeader(authorizationHeader, authorizationCookie));
        String issuer = decodedJWT.getIssuer();
        String keyId = decodedJWT.getKeyId();
        LOGGER.debug("Validating access-token for issuer: {} and keyId: {}", (Object)issuer, (Object)keyId);
        if (!issuer.equals("internal")) {
            throw new AuthorizationException(ErrorCode.PERMISSION_DENIED, "Invalid access token.");
        }
        JWTVerifier jwtVerifier = this.jwksOperations.verifierForIssuerAndKey(issuer, keyId);
        decodedJWT = jwtVerifier.verify(decodedJWT);
        String subject = decodedJWT.getSubject();
        try {
            user = this.userRepository.getUserByEmail(subject);
        }
        catch (Exception e) {
            LOGGER.debug("User not found: {}", (Object)subject);
            user = null;
        }
        if (user == null || user.getState() != User.StateEnum.ENABLED) {
            throw new AuthorizationException(ErrorCode.PERMISSION_DENIED, "User not allowed: " + subject);
        }
        LOGGER.debug("Access allowed for subject: {}", (Object)subject);
        ctx.setAttr(DECODED_JWT_ATTR, (Object)decodedJWT);
        return delegate.serve(ctx, req);
    }

    private String getAccessTokenFromCookieOrAuthHeader(String authorizationHeader, String authorizationCookie) {
        if (authorizationHeader != null && authorizationHeader.startsWith(BEARER_PREFIX)) {
            return authorizationHeader.substring(BEARER_PREFIX.length());
        }
        if (authorizationCookie != null) {
            return authorizationCookie;
        }
        throw new AuthorizationException(ErrorCode.UNAUTHENTICATED, "No authorization found.");
    }
}

