/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import io.unitycatalog.control.model.AccessTokenType;
import io.unitycatalog.control.model.GrantType;
import io.unitycatalog.control.model.OAuthTokenExchangeForm;
import io.unitycatalog.control.model.OAuthTokenExchangeInfo;
import io.unitycatalog.control.model.TokenEndpointExtensionType;
import io.unitycatalog.control.model.TokenType;
import io.unitycatalog.control.model.User;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.exception.OAuthInvalidRequestException;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.security.JwtClaim;
import io.unitycatalog.server.security.SecurityContext;
import io.unitycatalog.server.utils.JwksOperations;
import io.unitycatalog.server.utils.ServerProperties;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class AuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthService.class);
    private final UserRepository userRepository;
    private final SecurityContext securityContext;
    private final JwksOperations jwksOperations;
    private final ServerProperties serverProperties;
    private static final String EMPTY_RESPONSE = "{}";

    public AuthService(SecurityContext securityContext, ServerProperties serverProperties, Repositories repositories) {
        this.securityContext = securityContext;
        this.jwksOperations = new JwksOperations(securityContext);
        this.serverProperties = serverProperties;
        this.userRepository = repositories.getUserRepository();
    }

    @Post(value="/tokens")
    public HttpResponse grantToken(@Param(value="ext") Optional<TokenEndpointExtensionType> ext, @RequestConverter(value=ToOAuthTokenExchangeFormConverter.class) OAuthTokenExchangeForm form) {
        LOGGER.debug("Got token: {}", (Object)form);
        if (GrantType.TOKEN_EXCHANGE != form.getGrantType()) {
            throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "Unsupported grant type: " + String.valueOf((Object)form.getGrantType()));
        }
        if (TokenType.ACCESS_TOKEN != form.getRequestedTokenType()) {
            throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "Unsupported requested token type: " + String.valueOf((Object)form.getRequestedTokenType()));
        }
        if (form.getSubjectTokenType() == null) {
            throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "Subject token type is required but was not specified");
        }
        if (form.getActorTokenType() != null) {
            throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "Actor tokens not currently supported");
        }
        boolean authorizationEnabled = this.serverProperties.isAuthorizationEnabled();
        if (!authorizationEnabled) {
            throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "Authorization is disabled");
        }
        DecodedJWT decodedJWT = JWT.decode((String)form.getSubjectToken());
        String issuer = decodedJWT.getIssuer();
        String keyId = decodedJWT.getKeyId();
        LOGGER.debug("Validating token for issuer: {} and keyId: {}", (Object)issuer, (Object)keyId);
        JWTVerifier jwtVerifier = this.jwksOperations.verifierForIssuerAndKey(issuer, keyId);
        decodedJWT = jwtVerifier.verify(decodedJWT);
        this.verifyPrincipal(decodedJWT);
        LOGGER.debug("Validated. Creating access token.");
        String accessToken = this.securityContext.createAccessToken(decodedJWT);
        OAuthTokenExchangeInfo tokenExchangeInfo = new OAuthTokenExchangeInfo().accessToken(accessToken).issuedTokenType(TokenType.ACCESS_TOKEN).tokenType(AccessTokenType.BEARER);
        ResponseHeadersBuilder responseHeaders = ResponseHeaders.builder((HttpStatus)HttpStatus.OK);
        ext.ifPresent(e -> {
            if (e.equals((Object)TokenEndpointExtensionType.COOKIE)) {
                String cookieTimeout = this.serverProperties.getProperty("server.cookie-timeout", "P5D");
                Cookie cookie = this.createCookie("UC_TOKEN", accessToken, "/", cookieTimeout);
                responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, cookie.toSetCookieHeader());
            }
        });
        return HttpResponse.ofJson((ResponseHeaders)responseHeaders.build(), (Object)tokenExchangeInfo);
    }

    @Post(value="/logout")
    public HttpResponse logout(HttpRequest request) {
        return request.headers().cookies().stream().filter(c -> c.name().equals("UC_TOKEN")).findFirst().map(authorizationCookie -> {
            Cookie expiredCookie = this.createCookie("UC_TOKEN", "", "/", "PT0S");
            ResponseHeaders headers = ResponseHeaders.builder().status(HttpStatus.OK).add((CharSequence)HttpHeaderNames.SET_COOKIE, expiredCookie.toSetCookieHeader()).contentType(MediaType.JSON).build();
            return HttpResponse.of((ResponseHeaders)headers, (HttpData)HttpData.ofUtf8((String)EMPTY_RESPONSE));
        }).orElse(HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON, (String)EMPTY_RESPONSE));
    }

    private void verifyPrincipal(DecodedJWT decodedJWT) {
        String subject = decodedJWT.getClaims().getOrDefault(JwtClaim.EMAIL.key(), decodedJWT.getClaim(JwtClaim.SUBJECT.key())).asString();
        LOGGER.debug("Validating principal: {}", (Object)subject);
        if (subject.equals("admin")) {
            LOGGER.debug("admin always allowed");
            return;
        }
        try {
            User user = this.userRepository.getUserByEmail(subject);
            if (user != null && user.getState() == User.StateEnum.ENABLED) {
                LOGGER.debug("Principal {} is enabled", (Object)subject);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new OAuthInvalidRequestException(ErrorCode.INVALID_ARGUMENT, "User not allowed: " + subject);
    }

    private Cookie createCookie(String key, String value, String path, String maxAge) {
        return Cookie.secureBuilder((String)key, (String)value).path(path).maxAge(Duration.parse(maxAge).getSeconds()).build();
    }

    private static class ToOAuthTokenExchangeFormConverter
    implements RequestConverterFunction {
        private static final ObjectMapper mapper = new ObjectMapper();

        private ToOAuthTokenExchangeFormConverter() {
        }

        public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) {
            MediaType contentType = request.contentType();
            if (expectedResultType == OAuthTokenExchangeForm.class && contentType != null && contentType.belongsTo(MediaType.FORM_DATA)) {
                Map<String, String> form = QueryParams.fromQueryString((String)request.content(contentType.charset(StandardCharsets.UTF_8))).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                return mapper.convertValue(form, OAuthTokenExchangeForm.class);
            }
            return RequestConverterFunction.fallthrough();
        }
    }
}

