/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.model.Privileges;
import java.util.UUID;

public abstract class AuthorizedService {
    protected final UnityCatalogAuthorizer authorizer;
    protected final UnityAccessEvaluator evaluator;
    protected final UserRepository userRepository;

    protected AuthorizedService(UnityCatalogAuthorizer authorizer, UserRepository userRepository) {
        this.authorizer = authorizer;
        this.evaluator = new UnityAccessEvaluator(authorizer);
        this.userRepository = userRepository;
    }

    protected void initializeBasicAuthorization(String resourceId) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.authorizer.grantAuthorization(principalId, UUID.fromString(resourceId), Privileges.OWNER);
    }

    protected void initializeHierarchicalAuthorization(String resourceId, String parentId) {
        this.initializeBasicAuthorization(resourceId);
        this.authorizer.addHierarchyChild(UUID.fromString(parentId), UUID.fromString(resourceId));
    }

    protected void removeAuthorizations(String resourceId) {
        this.authorizer.clearAuthorizationsForResource(UUID.fromString(resourceId));
    }

    protected void removeHierarchicalAuthorizations(String resourceId, String parentId) {
        this.removeAuthorizations(resourceId);
        this.authorizer.removeHierarchyChild(UUID.fromString(parentId), UUID.fromString(resourceId));
    }
}

