/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateCatalog;
import io.unitycatalog.server.model.ListCatalogsResponse;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateCatalog;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class CatalogService
extends AuthorizedService {
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;

    public CatalogService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.catalogRepository = repositories.getCatalogRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorizeAny(#principal, #metastore, OWNER, CREATE_CATALOG)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createCatalog(CreateCatalog createCatalog) {
        CatalogInfo catalogInfo = this.catalogRepository.addCatalog(createCatalog);
        this.initializeBasicAuthorization(catalogInfo.getId());
        return HttpResponse.ofJson((Object)catalogInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listCatalogs(@Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListCatalogsResponse listCatalogsResponse = this.catalogRepository.listCatalogs(maxResults, pageToken);
        this.filterCatalogs("#authorize(#principal, #metastore, OWNER) ||\n#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG)\n", listCatalogsResponse.getCatalogs());
        return HttpResponse.ofJson((Object)listCatalogsResponse);
    }

    @Get(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getCatalog(@Param(value="name") @AuthorizeKey(value=SecurableType.CATALOG) String name) {
        return HttpResponse.ofJson((Object)this.catalogRepository.getCatalog(name));
    }

    @Patch(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #catalog, OWNER)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateCatalog(@Param(value="name") @AuthorizeKey(value=SecurableType.CATALOG) String name, UpdateCatalog updateCatalog) {
        return HttpResponse.ofJson((Object)this.catalogRepository.updateCatalog(name, updateCatalog));
    }

    @Delete(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteCatalog(@Param(value="name") @AuthorizeKey(value=SecurableType.CATALOG) String name, @Param(value="force") Optional<Boolean> force) {
        CatalogInfo catalogInfo = this.catalogRepository.getCatalog(name);
        this.catalogRepository.deleteCatalog(name, force.orElse(false));
        this.removeAuthorizations(catalogInfo.getId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    public void filterCatalogs(String expression, List<CatalogInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, ci -> Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(ci.getId())));
    }
}

