/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CreateCredentialRequest;
import io.unitycatalog.server.model.CredentialInfo;
import io.unitycatalog.server.model.ListCredentialsResponse;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateCredentialRequest;
import io.unitycatalog.server.persist.CredentialRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.Optional;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class CredentialService
extends AuthorizedService {
    private final CredentialRepository credentialRepository;

    public CredentialService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.credentialRepository = repositories.getCredentialRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createCredential(CreateCredentialRequest createCredentialRequest) {
        CredentialInfo credentialInfo = this.credentialRepository.addCredential(createCredentialRequest);
        this.initializeBasicAuthorization(credentialInfo.getId());
        return HttpResponse.ofJson((Object)credentialInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    public HttpResponse listCredentials(@Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListCredentialsResponse credentials = this.credentialRepository.listCredentials(maxResults, pageToken);
        return HttpResponse.ofJson((Object)credentials);
    }

    @Get(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getCredential(@Param(value="name") String name) {
        return HttpResponse.ofJson((Object)this.credentialRepository.getCredential(name));
    }

    @Patch(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateCredential(@Param(value="name") String name, UpdateCredentialRequest updateRequest) {
        return HttpResponse.ofJson((Object)this.credentialRepository.updateCredential(name, updateRequest));
    }

    @Delete(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteCredential(@Param(value="name") String name) {
        CredentialInfo credentialInfo = this.credentialRepository.deleteCredential(name);
        this.removeAuthorizations(credentialInfo.getId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }
}

