/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CreateExternalLocation;
import io.unitycatalog.server.model.ListExternalLocationsResponse;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateExternalLocation;
import io.unitycatalog.server.persist.ExternalLocationRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.dao.ExternalLocationDAO;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.Optional;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class ExternalLocationService
extends AuthorizedService {
    private final ExternalLocationRepository externalLocationRepository;

    public ExternalLocationService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.externalLocationRepository = repositories.getExternalLocationRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createExternalLocation(CreateExternalLocation createExternalLocation) {
        ExternalLocationDAO externalLocationDAO = this.externalLocationRepository.addExternalLocation(createExternalLocation);
        this.initializeBasicAuthorization(externalLocationDAO.getId().toString());
        return HttpResponse.ofJson((Object)externalLocationDAO.toExternalLocationInfo());
    }

    @Get(value="")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse listExternalLocations(@Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListExternalLocationsResponse locations = this.externalLocationRepository.listExternalLocations(maxResults, pageToken);
        return HttpResponse.ofJson((Object)locations);
    }

    @Get(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getExternalLocation(@Param(value="name") String name) {
        return HttpResponse.ofJson((Object)this.externalLocationRepository.getExternalLocation(name));
    }

    @Patch(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #externalLocation, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateExternalLocation(@Param(value="name") String name, UpdateExternalLocation updateRequest) {
        return HttpResponse.ofJson((Object)this.externalLocationRepository.updateExternalLocation(name, updateRequest));
    }

    @Delete(value="/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteExternalLocation(@Param(value="name") String name) {
        ExternalLocationDAO externalLocationDAO = this.externalLocationRepository.deleteExternalLocation(name);
        this.removeAuthorizations(externalLocationDAO.getId().toString());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }
}

