/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.auth.annotation.AuthorizeKeys;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateFunctionRequest;
import io.unitycatalog.server.model.FunctionInfo;
import io.unitycatalog.server.model.ListFunctionsResponse;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.FunctionRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class FunctionService
extends AuthorizedService {
    private final FunctionRepository functionRepository;
    private final SchemaRepository schemaRepository;
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;

    public FunctionService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.catalogRepository = repositories.getCatalogRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.functionRepository = repositories.getFunctionRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createFunction(@AuthorizeKeys(value={@AuthorizeKey(value=SecurableType.CATALOG, key="function_info.catalog_name"), @AuthorizeKey(value=SecurableType.SCHEMA, key="function_info.schema_name")}) CreateFunctionRequest createFunctionRequest) {
        FunctionInfo functionInfo = this.functionRepository.createFunction(createFunctionRequest);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(functionInfo.getCatalogName() + "." + functionInfo.getSchemaName());
        this.initializeHierarchicalAuthorization(functionInfo.getFunctionId(), schemaInfo.getSchemaId());
        return HttpResponse.ofJson((Object)functionInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listFunctions(@Param(value="catalog_name") String catalogName, @Param(value="schema_name") String schemaName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListFunctionsResponse listFunctionsResponse = this.functionRepository.listFunctions(catalogName, schemaName, maxResults, pageToken);
        this.filterFunctions("#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorizeAny(#principal, #catalog, USE_CATALOG) && #authorizeAny(#principal, #function, OWNER, EXECUTE))\n", listFunctionsResponse.getFunctions());
        return HttpResponse.ofJson((Object)listFunctionsResponse);
    }

    @Get(value="/{name}")
    @AuthorizeKey(value=SecurableType.METASTORE)
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorizeAny(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, USE_SCHEMA) && #authorizeAny(#principal, #function, OWNER, EXECUTE))\n")
    public HttpResponse getFunction(@Param(value="name") @AuthorizeKey(value=SecurableType.FUNCTION) String name) {
        return HttpResponse.ofJson((Object)this.functionRepository.getFunction(name));
    }

    @Delete(value="/{name}")
    @AuthorizeKey(value=SecurableType.METASTORE)
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n(#authorize(#principal, #function, OWNER) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n")
    public HttpResponse deleteFunction(@Param(value="name") @AuthorizeKey(value=SecurableType.FUNCTION) String name, @Param(value="force") Optional<Boolean> force) {
        FunctionInfo functionInfo = this.functionRepository.getFunction(name);
        this.functionRepository.deleteFunction(name, force.orElse(false));
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(functionInfo.getCatalogName() + "." + functionInfo.getSchemaName());
        this.removeHierarchicalAuthorizations(functionInfo.getFunctionId(), schemaInfo.getSchemaId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    public void filterFunctions(String expression, List<FunctionInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, fi -> {
            CatalogInfo catalogInfo = this.catalogRepository.getCatalog(fi.getCatalogName());
            SchemaInfo schemaInfo = this.schemaRepository.getSchema(fi.getCatalogName() + "." + fi.getSchemaName());
            return Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(catalogInfo.getId()), SecurableType.SCHEMA, UUID.fromString(schemaInfo.getSchemaId()), SecurableType.FUNCTION, UUID.fromString(fi.getFunctionId()));
        });
    }
}

