/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Head;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import io.unitycatalog.server.exception.IcebergRestExceptionHandler;
import io.unitycatalog.server.model.ListSchemasResponse;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.service.CatalogService;
import io.unitycatalog.server.service.SchemaService;
import io.unitycatalog.server.service.TableService;
import io.unitycatalog.server.service.iceberg.MetadataService;
import io.unitycatalog.server.service.iceberg.TableConfigService;
import io.unitycatalog.server.utils.JsonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

@ExceptionHandler(value=IcebergRestExceptionHandler.class)
public class IcebergRestCatalogService {
    private static final String PREFIX_BASE = "catalogs/";
    private static final List<Endpoint> ENDPOINTS = List.of(Endpoint.V1_LIST_NAMESPACES, Endpoint.V1_LOAD_NAMESPACE, Endpoint.V1_TABLE_EXISTS, Endpoint.V1_LOAD_TABLE, Endpoint.V1_LOAD_VIEW, Endpoint.V1_REPORT_METRICS, Endpoint.V1_LIST_TABLES);
    private final CatalogService catalogService;
    private final SchemaService schemaService;
    private final TableService tableService;
    private final TableConfigService tableConfigService;
    private final MetadataService metadataService;
    private final TableRepository tableRepository;
    private final SessionFactory sessionFactory;

    public IcebergRestCatalogService(CatalogService catalogService, SchemaService schemaService, TableService tableService, TableConfigService tableConfigService, MetadataService metadataService, Repositories repositories) {
        this.catalogService = catalogService;
        this.schemaService = schemaService;
        this.tableService = tableService;
        this.tableConfigService = tableConfigService;
        this.metadataService = metadataService;
        this.tableRepository = repositories.getTableRepository();
        this.sessionFactory = repositories.getSessionFactory();
    }

    @Get(value="/v1/config")
    @ProducesJson
    public ConfigResponse config(@Param(value="warehouse") Optional<String> catalogOpt) {
        String catalog = catalogOpt.orElseThrow(() -> new BadRequestException("Must supply a proper catalog in warehouse property.", new Object[0]));
        return ConfigResponse.builder().withOverride("prefix", PREFIX_BASE + catalog).withEndpoints(ENDPOINTS).build();
    }

    @Get(value="/v1/catalogs/{catalog}/namespaces")
    @ProducesJson
    public ListNamespacesResponse listNamespaces(@Param(value="catalog") String catalog, @Param(value="parent") Optional<String> parent) throws JsonProcessingException {
        List namespaces;
        if (parent.isPresent() && !parent.get().isEmpty()) {
            namespaces = Collections.emptyList();
        } else {
            String respContent = ((AggregatedHttpResponse)this.schemaService.listSchemas(catalog, Optional.of(Integer.MAX_VALUE), Optional.empty()).aggregate().join()).contentUtf8();
            ListSchemasResponse resp = (ListSchemasResponse)JsonUtils.getInstance().readValue(respContent, ListSchemasResponse.class);
            assert (resp.getSchemas() != null);
            namespaces = resp.getSchemas().stream().map(schemaInfo -> Namespace.of((String[])new String[]{schemaInfo.getName()})).collect(Collectors.toList());
        }
        return ListNamespacesResponse.builder().addAll(namespaces).build();
    }

    @Get(value="/v1/catalogs/{catalog}/namespaces/{namespace}")
    @ProducesJson
    public GetNamespaceResponse getNamespace(@Param(value="catalog") String catalog, @Param(value="namespace") String namespace) throws JsonProcessingException {
        String schemaFullName = String.join((CharSequence)".", catalog, namespace);
        String resp = ((AggregatedHttpResponse)this.schemaService.getSchema(schemaFullName).aggregate().join()).contentUtf8();
        return GetNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{namespace})).setProperties(((SchemaInfo)JsonUtils.getInstance().readValue(resp, SchemaInfo.class)).getProperties()).build();
    }

    @Head(value="/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}")
    public HttpResponse tableExists(@Param(value="catalog") String catalog, @Param(value="namespace") String namespace, @Param(value="table") String table) {
        try (Session session = this.sessionFactory.openSession();){
            this.tableRepository.getTable(catalog + "." + namespace + "." + table);
            String metadataLocation = this.tableRepository.getTableUniformMetadataLocation(session, catalog, namespace, table);
            if (metadataLocation == null) {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{namespace + "." + table});
            }
            HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.OK);
            return httpResponse;
        }
    }

    @Get(value="/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}")
    @ProducesJson
    public LoadTableResponse loadTable(@Param(value="catalog") String catalog, @Param(value="namespace") String namespace, @Param(value="table") String table) {
        String metadataLocation;
        try (Session session = this.sessionFactory.openSession();){
            this.tableRepository.getTable(catalog + "." + namespace + "." + table);
            metadataLocation = this.tableRepository.getTableUniformMetadataLocation(session, catalog, namespace, table);
        }
        if (metadataLocation == null) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{namespace + "." + table});
        }
        TableMetadata tableMetadata = this.metadataService.readTableMetadata(metadataLocation);
        Map<String, String> config = this.tableConfigService.getTableConfig(tableMetadata);
        return LoadTableResponse.builder().withTableMetadata(tableMetadata).addAllConfig(config).build();
    }

    @Get(value="/v1/catalogs/{catalog}/namespaces/{namespace}/views/{view}")
    @ProducesJson
    public LoadViewResponse loadView(@Param(value="namespace") String namespace, @Param(value="view") String view) {
        throw new NoSuchViewException("View does not exist: %s", new Object[]{namespace + "." + view});
    }

    @Post(value="/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}/metrics")
    public HttpResponse reportMetrics(@Param(value="namespace") String namespace, @Param(value="table") String table) {
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @Get(value="/v1/catalogs/{catalog}/namespaces/{namespace}/tables")
    @ProducesJson
    public ListTablesResponse listTables(@Param(value="catalog") String catalog, @Param(value="namespace") String namespace) throws JsonProcessingException {
        List filteredTables;
        AggregatedHttpResponse resp = (AggregatedHttpResponse)this.tableService.listTables(catalog, namespace, Optional.of(Integer.MAX_VALUE), Optional.empty(), Optional.empty(), Optional.empty()).aggregate().join();
        try (Session session = this.sessionFactory.openSession();){
            filteredTables = Objects.requireNonNull(((io.unitycatalog.server.model.ListTablesResponse)JsonUtils.getInstance().readValue(resp.contentUtf8(), io.unitycatalog.server.model.ListTablesResponse.class)).getTables()).stream().filter(tableInfo -> {
                String metadataLocation = this.tableRepository.getTableUniformMetadataLocation(session, catalog, namespace, tableInfo.getName());
                return metadataLocation != null;
            }).map(tableInfo -> TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{tableInfo.getSchemaName()}), (String)tableInfo.getName())).collect(Collectors.toList());
        }
        return ListTablesResponse.builder().addAll(filteredTables).build();
    }
}

