/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.auth.annotation.AuthorizeKeys;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateModelVersion;
import io.unitycatalog.server.model.CreateRegisteredModel;
import io.unitycatalog.server.model.FinalizeModelVersion;
import io.unitycatalog.server.model.ListRegisteredModelsResponse;
import io.unitycatalog.server.model.ModelVersionInfo;
import io.unitycatalog.server.model.RegisteredModelInfo;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateModelVersion;
import io.unitycatalog.server.model.UpdateRegisteredModel;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.ModelRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class ModelService
extends AuthorizedService {
    private final ModelRepository modelRepository;
    private final SchemaRepository schemaRepository;
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;
    private final UnityAccessEvaluator evaluator;

    public ModelService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.evaluator = new UnityAccessEvaluator(authorizer);
        this.catalogRepository = repositories.getCatalogRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.modelRepository = repositories.getModelRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="(#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAll(#principal, #schema, USE_SCHEMA, CREATE_MODEL)) ||\n(#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAll(#principal, #schema, USE_SCHEMA, CREATE_FUNCTION))\n")
    public HttpResponse createRegisteredModel(@AuthorizeKeys(value={@AuthorizeKey(value=SecurableType.SCHEMA, key="schema_name"), @AuthorizeKey(value=SecurableType.CATALOG, key="catalog_name")}) CreateRegisteredModel createRegisteredModel) {
        assert (createRegisteredModel != null);
        RegisteredModelInfo createRegisteredModelResponse = this.modelRepository.createRegisteredModel(createRegisteredModel);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(createRegisteredModelResponse.getCatalogName() + "." + createRegisteredModelResponse.getSchemaName());
        this.initializeHierarchicalAuthorization(createRegisteredModelResponse.getId(), schemaInfo.getSchemaId());
        return HttpResponse.ofJson((Object)createRegisteredModelResponse);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listRegisteredModels(@Param(value="catalog_name") Optional<String> catalogName, @Param(value="schema_name") Optional<String> schemaName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListRegisteredModelsResponse listRegisteredModelsResponse = this.modelRepository.listRegisteredModels(catalogName, schemaName, maxResults, pageToken);
        this.filterModels("#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorizeAny(#principal, #registered_model, OWNER, EXECUTE) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n", listRegisteredModelsResponse.getRegisteredModels());
        return HttpResponse.ofJson((Object)listRegisteredModelsResponse);
    }

    @Get(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorizeAny(#principal, #registered_model, OWNER, EXECUTE) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getRegisteredModel(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullNameArg) {
        assert (fullNameArg != null);
        RegisteredModelInfo registeredModelInfo = this.modelRepository.getRegisteredModel(fullNameArg);
        return HttpResponse.ofJson((Object)registeredModelInfo);
    }

    @Patch(value="/{full_name}")
    @AuthorizeExpression(value="(#authorize(#principal, #registered_model, OWNER) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateRegisteredModel(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, UpdateRegisteredModel updateRegisteredModel) {
        assert (updateRegisteredModel != null);
        RegisteredModelInfo updateRegisteredModelResponse = this.modelRepository.updateRegisteredModel(fullName, updateRegisteredModel);
        return HttpResponse.ofJson((Object)updateRegisteredModelResponse);
    }

    @Delete(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorize(#principal, #registered_model, OWNER) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteRegisteredModel(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, @Param(value="force") Optional<Boolean> force) {
        RegisteredModelInfo registeredModelInfo = this.modelRepository.getRegisteredModel(fullName);
        this.modelRepository.deleteRegisteredModel(fullName, force.orElse(false));
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(registeredModelInfo.getCatalogName() + "." + registeredModelInfo.getSchemaName());
        this.removeHierarchicalAuthorizations(registeredModelInfo.getId(), schemaInfo.getSchemaId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @Post(value="/versions")
    @AuthorizeExpression(value="(#authorize(#principal, #registered_model, OWNER) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n")
    public HttpResponse createModelVersion(@AuthorizeKeys(value={@AuthorizeKey(value=SecurableType.CATALOG, key="catalog_name"), @AuthorizeKey(value=SecurableType.SCHEMA, key="schema_name"), @AuthorizeKey(value=SecurableType.REGISTERED_MODEL, key="model_name")}) CreateModelVersion createModelVersion) {
        assert (createModelVersion != null);
        assert (createModelVersion.getModelName() != null);
        assert (createModelVersion.getCatalogName() != null);
        assert (createModelVersion.getSchemaName() != null);
        assert (createModelVersion.getSource() != null);
        ModelVersionInfo createModelVersionResponse = this.modelRepository.createModelVersion(createModelVersion);
        return HttpResponse.ofJson((Object)createModelVersionResponse);
    }

    @Get(value="/{full_name}/versions")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorizeAny(#principal, #registered_model, OWNER, EXECUTE) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse listModelVersions(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        return HttpResponse.ofJson((Object)this.modelRepository.listModelVersions(fullName, maxResults, pageToken));
    }

    @Get(value="/{full_name}/versions/{version}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorizeAny(#principal, #registered_model, OWNER, EXECUTE) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getModelVersion(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, @Param(value="version") Long version) {
        assert (fullName != null && version != null);
        ModelVersionInfo modelVersionInfo = this.modelRepository.getModelVersion(fullName, version);
        return HttpResponse.ofJson((Object)modelVersionInfo);
    }

    @Patch(value="/{full_name}/versions/{version}")
    @AuthorizeExpression(value="(#authorize(#principal, #registered_model, OWNER) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateModelVersion(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, @Param(value="version") Long version, UpdateModelVersion updateModelVersion) {
        assert (updateModelVersion != null);
        ModelVersionInfo updateModelVersionResponse = this.modelRepository.updateModelVersion(fullName, version, updateModelVersion);
        return HttpResponse.ofJson((Object)updateModelVersionResponse);
    }

    @Delete(value="/{full_name}/versions/{version}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorize(#principal, #registered_model, OWNER) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteModelVersion(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, @Param(value="version") Long version) {
        this.modelRepository.deleteModelVersion(fullName, version);
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @Patch(value="/{full_name}/versions/{version}/finalize")
    @AuthorizeExpression(value="(#authorize(#principal, #registered_model, OWNER) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse finalizeModelVersion(@Param(value="full_name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String fullName, FinalizeModelVersion finalizeModelVersion) {
        assert (finalizeModelVersion != null);
        ModelVersionInfo finalizeModelVersionResponse = this.modelRepository.finalizeModelVersion(finalizeModelVersion);
        return HttpResponse.ofJson((Object)finalizeModelVersionResponse);
    }

    public void filterModels(String expression, List<RegisteredModelInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, ti -> {
            CatalogInfo catalogInfo = this.catalogRepository.getCatalog(ti.getCatalogName());
            SchemaInfo schemaInfo = this.schemaRepository.getSchema(ti.getCatalogName() + "." + ti.getSchemaName());
            return Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(catalogInfo.getId()), SecurableType.SCHEMA, UUID.fromString(schemaInfo.getSchemaId()), SecurableType.REGISTERED_MODEL, UUID.fromString(ti.getId()));
        });
    }
}

