/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import io.unitycatalog.control.model.User;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.PermissionsChange;
import io.unitycatalog.server.model.PermissionsList;
import io.unitycatalog.server.model.Privilege;
import io.unitycatalog.server.model.PrivilegeAssignment;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdatePermissions;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.FunctionRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.ModelRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.VolumeRepository;
import io.unitycatalog.server.persist.model.Privileges;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class PermissionService {
    private final UnityCatalogAuthorizer authorizer;
    private final MetastoreRepository metastoreRepository;
    private final UserRepository userRepository;
    private final CatalogRepository catalogRepository;
    private final SchemaRepository schemaRepository;
    private final TableRepository tableRepository;
    private final FunctionRepository functionRepository;
    private final VolumeRepository volumeRepository;
    private final ModelRepository modelRepository;

    public PermissionService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        this.authorizer = authorizer;
        this.metastoreRepository = repositories.getMetastoreRepository();
        this.userRepository = repositories.getUserRepository();
        this.catalogRepository = repositories.getCatalogRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.tableRepository = repositories.getTableRepository();
        this.functionRepository = repositories.getFunctionRepository();
        this.volumeRepository = repositories.getVolumeRepository();
        this.modelRepository = repositories.getModelRepository();
    }

    @Get(value="/metastore/{name}")
    public HttpResponse getMetastoreAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.METASTORE, name);
    }

    @Get(value="/catalog/{name}")
    public HttpResponse getCatalogAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.CATALOG, name);
    }

    @Get(value="/schema/{name}")
    public HttpResponse getSchemaAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.SCHEMA, name);
    }

    @Get(value="/table/{name}")
    public HttpResponse getTableAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.TABLE, name);
    }

    @Get(value="/function/{name}")
    public HttpResponse getFunctionAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.FUNCTION, name);
    }

    @Get(value="/volume/{name}")
    public HttpResponse getVolumeAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.VOLUME, name);
    }

    @Get(value="/registered_model/{name}")
    public HttpResponse getRegisteredModelAuthorization(@Param(value="name") String name) {
        return this.getAuthorization(SecurableType.REGISTERED_MODEL, name);
    }

    private HttpResponse getAuthorization(SecurableType securableType, String name) {
        UUID resourceId = this.getResourceId(securableType, name);
        UUID principalId = this.userRepository.findPrincipalId();
        UUID parentId = this.authorizer.getHierarchyParent(resourceId);
        UUID grandparentId = parentId != null ? this.authorizer.getHierarchyParent(parentId) : null;
        boolean isOwner = this.authorizer.authorize(principalId, this.metastoreRepository.getMetastoreId(), Privileges.OWNER) || this.authorizer.authorize(principalId, resourceId, Privileges.OWNER) || parentId != null && this.authorizer.authorize(principalId, parentId, Privileges.OWNER) || grandparentId != null && this.authorizer.authorize(principalId, grandparentId, Privileges.OWNER);
        Map<UUID, List<Privileges>> authorizations = isOwner ? this.authorizer.listAuthorizations(resourceId) : Map.of(principalId, this.authorizer.listAuthorizations(principalId, resourceId));
        List<PrivilegeAssignment> privilegeAssignments = authorizations.entrySet().stream().map(entry -> {
            List<Privilege> privileges = ((List)entry.getValue()).stream().map(Privileges::toPrivilege).filter(Objects::nonNull).toList();
            return new PrivilegeAssignment().principal(this.userRepository.getUser(((UUID)entry.getKey()).toString()).getEmail()).privileges(privileges);
        }).filter(assignment -> !assignment.getPrivileges().isEmpty()).collect(Collectors.toList());
        return HttpResponse.ofJson((Object)new PermissionsList().privilegeAssignments(privilegeAssignments));
    }

    @Patch(value="/metastore/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateMetastoreAuthorization(@Param(value="name") String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.METASTORE, name, request);
    }

    @Patch(value="/catalog/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) || #authorize(#principal, #catalog, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateCatalogAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.CATALOG) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.CATALOG, name, request);
    }

    @Patch(value="/schema/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateSchemaAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.SCHEMA) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.SCHEMA, name, request);
    }

    @Patch(value="/table/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #table, OWNER))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateTableAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.TABLE) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.TABLE, name, request);
    }

    @Patch(value="/function/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #function, OWNER))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateFunctionAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.FUNCTION) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.FUNCTION, name, request);
    }

    @Patch(value="/volume/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n(#authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #volume, OWNER))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateVolumeAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.VOLUME) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.VOLUME, name, request);
    }

    @Patch(value="/registered_model/{name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) || #authorize(#principal, #registered_model, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateRegisteredModelAuthorization(@Param(value="name") @AuthorizeKey(value=SecurableType.REGISTERED_MODEL) String name, UpdatePermissions request) {
        return this.updateAuthorization(SecurableType.REGISTERED_MODEL, name, request);
    }

    private HttpResponse updateAuthorization(SecurableType securableType, String name, UpdatePermissions request) {
        UUID resourceId = this.getResourceId(securableType, name);
        List<PermissionsChange> changes = request.getChanges();
        HashSet principalIds = new HashSet();
        changes.forEach(change -> {
            String principal = change.getPrincipal();
            User user = this.userRepository.getUserByEmail(principal);
            UUID principalId = UUID.fromString(Objects.requireNonNull(user.getId()));
            principalIds.add(principalId);
            change.getAdd().forEach(privilege -> Optional.ofNullable(Privileges.fromPrivilege(privilege)).map(p -> this.authorizer.grantAuthorization(principalId, resourceId, (Privileges)((Object)((Object)((Object)p))))));
            change.getRemove().forEach(privilege -> Optional.ofNullable(Privileges.fromPrivilege(privilege)).map(p -> this.authorizer.revokeAuthorization(principalId, resourceId, (Privileges)((Object)((Object)((Object)p))))));
        });
        Map<UUID, List<Privileges>> authorizations = this.authorizer.listAuthorizations(resourceId);
        List<PrivilegeAssignment> privilegeAssignments = authorizations.entrySet().stream().filter(entry -> principalIds.contains(entry.getKey())).map(entry -> {
            List<Privilege> privileges = ((List)entry.getValue()).stream().map(Privileges::toPrivilege).filter(Objects::nonNull).toList();
            return new PrivilegeAssignment().principal(this.userRepository.getUser(((UUID)entry.getKey()).toString()).getEmail()).privileges(privileges);
        }).filter(assignment -> !assignment.getPrivileges().isEmpty()).collect(Collectors.toList());
        return HttpResponse.ofJson((Object)new PermissionsList().privilegeAssignments(privilegeAssignments));
    }

    private UUID getResourceId(SecurableType securableType, String name) {
        String resourceId = switch (securableType) {
            case SecurableType.METASTORE -> this.metastoreRepository.getMetastoreId().toString();
            case SecurableType.CATALOG -> this.catalogRepository.getCatalog(name).getId();
            case SecurableType.SCHEMA -> this.schemaRepository.getSchema(name).getSchemaId();
            case SecurableType.TABLE -> this.tableRepository.getTable(name).getTableId();
            case SecurableType.FUNCTION -> this.functionRepository.getFunction(name).getFunctionId();
            case SecurableType.VOLUME -> this.volumeRepository.getVolume(name).getVolumeId();
            case SecurableType.REGISTERED_MODEL -> this.modelRepository.getRegisteredModel(name).getId();
            default -> throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Unknown resource type");
        };
        return UUID.fromString(Objects.requireNonNull(resourceId));
    }
}

