/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateSchema;
import io.unitycatalog.server.model.ListSchemasResponse;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateSchema;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class SchemaService
extends AuthorizedService {
    private final SchemaRepository schemaRepository;
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;

    public SchemaService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.schemaRepository = repositories.getSchemaRepository();
        this.catalogRepository = repositories.getCatalogRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorize(#principal, #catalog, OWNER) ||\n#authorizeAll(#principal, #catalog, USE_CATALOG, CREATE_SCHEMA)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createSchema(@AuthorizeKey(value=SecurableType.CATALOG, key="catalog_name") CreateSchema createSchema) {
        SchemaInfo schemaInfo = this.schemaRepository.createSchema(createSchema);
        CatalogInfo catalogInfo = this.catalogRepository.getCatalog(schemaInfo.getCatalogName());
        this.initializeHierarchicalAuthorization(schemaInfo.getSchemaId(), catalogInfo.getId());
        return HttpResponse.ofJson((Object)schemaInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listSchemas(@Param(value="catalog_name") String catalogName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken) {
        ListSchemasResponse listSchemasResponse = this.schemaRepository.listSchemas(catalogName, maxResults, pageToken);
        this.filterSchemas("#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG))\n", listSchemasResponse.getSchemas());
        return HttpResponse.ofJson((Object)listSchemasResponse);
    }

    @Get(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getSchema(@Param(value="full_name") @AuthorizeKey(value=SecurableType.SCHEMA) String fullName) {
        return HttpResponse.ofJson((Object)this.schemaRepository.getSchema(fullName));
    }

    @Patch(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #schema, OWNER) ||\n#authorizeAll(#principal, #catalog, USE_CATALOG, USE_SCHEMA) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateSchema(@Param(value="full_name") @AuthorizeKey(value=SecurableType.SCHEMA) String fullName, UpdateSchema updateSchema) {
        return HttpResponse.ofJson((Object)this.schemaRepository.updateSchema(fullName, updateSchema));
    }

    @Delete(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorizeAny(#principal, #catalog, USE_CATALOG))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteSchema(@Param(value="full_name") @AuthorizeKey(value=SecurableType.SCHEMA) String fullName, @Param(value="force") Optional<Boolean> force) {
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(fullName);
        this.schemaRepository.deleteSchema(fullName, force.orElse(false));
        CatalogInfo catalogInfo = this.catalogRepository.getCatalog(schemaInfo.getCatalogName());
        this.authorizer.removeHierarchyChildren(UUID.fromString(schemaInfo.getSchemaId()));
        this.removeHierarchicalAuthorizations(schemaInfo.getSchemaId(), catalogInfo.getId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    public void filterSchemas(String expression, List<SchemaInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, si -> {
            CatalogInfo catalogInfo = this.catalogRepository.getCatalog(si.getCatalogName());
            return Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(catalogInfo.getId()), SecurableType.SCHEMA, UUID.fromString(si.getSchemaId()));
        });
    }
}

