/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Produces;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.types.UserResource;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.exception.Scim2RuntimeException;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.security.JwtClaim;
import io.unitycatalog.server.service.AuthDecorator;
import io.unitycatalog.server.utils.Scim2Utils;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class Scim2SelfService {
    private final UserRepository userRepository;
    private final UnityCatalogAuthorizer authorizer;

    public Scim2SelfService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        this.authorizer = authorizer;
        this.userRepository = repositories.getUserRepository();
    }

    @Get(value="")
    @Produces(value="application/scim+json")
    @StatusCode(value=200)
    @AuthorizeExpression(value="#principal != null")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public UserResource getCurrentUser() {
        ServiceRequestContext ctx = ServiceRequestContext.current();
        DecodedJWT decodedJWT = (DecodedJWT)ctx.attr(AuthDecorator.DECODED_JWT_ATTR);
        if (decodedJWT != null) {
            Claim sub = decodedJWT.getClaim(JwtClaim.SUBJECT.key());
            return Scim2Utils.asUserResource(this.userRepository.getUserByEmail(sub.asString()));
        }
        throw new Scim2RuntimeException((ScimException)new BadRequestException("No user found."));
    }
}

