/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.Produces;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.messages.ListResponse;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.Photo;
import com.unboundid.scim2.common.types.UserResource;
import com.unboundid.scim2.common.utils.FilterEvaluator;
import com.unboundid.scim2.common.utils.Parser;
import io.unitycatalog.control.model.User;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.exception.Scim2RuntimeException;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.model.CreateUser;
import io.unitycatalog.server.persist.model.UpdateUser;
import io.unitycatalog.server.utils.Scim2Utils;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class Scim2UserService {
    private final UserRepository userRepository;
    private final UnityCatalogAuthorizer authorizer;

    public Scim2UserService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        this.authorizer = authorizer;
        this.userRepository = repositories.getUserRepository();
    }

    @Get(value="")
    @Produces(value="application/scim+json")
    @StatusCode(value=200)
    @AuthorizeExpression(value="#principal != null")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public ListResponse<UserResource> getScimUsers(@Param(value="filter") Optional<String> filter, @Param(value="startIndex") Optional<Integer> startIndex, @Param(value="count") Optional<Integer> count) {
        Filter userFilter = filter.filter(f -> !f.isEmpty()).map(this::parseFilter).orElse(null);
        FilterEvaluator filterEvaluator = new FilterEvaluator();
        List<UserResource> userResourcesList = this.userRepository.listUsers(startIndex.orElse(1) - 1, count.orElse(50), m -> this.match(filterEvaluator, userFilter, Scim2Utils.asUserResource(m))).stream().map(Scim2Utils::asUserResource).toList();
        Meta meta = new Meta();
        meta.setCreated(Calendar.getInstance());
        meta.setLastModified(Calendar.getInstance());
        meta.setResourceType("User");
        ListResponse userResources = new ListResponse(userResourcesList.size(), userResourcesList, startIndex.orElse(1), Integer.valueOf(userResourcesList.size()));
        userResources.setMeta(meta);
        return userResources;
    }

    @Post(value="")
    @Produces(value="application/scim+json")
    @StatusCode(value=201)
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public UserResource createScimUser(UserResource userResource) {
        Email primaryEmail = userResource.getEmails().stream().filter(Email::getPrimary).findFirst().orElseThrow(() -> new Scim2RuntimeException((ScimException)new PreconditionFailedException("User does not have a primary email.")));
        String pictureUrl = "";
        if (userResource.getPhotos() != null && !userResource.getPhotos().isEmpty()) {
            pictureUrl = ((Photo)userResource.getPhotos().get(0)).getValue().toString();
        }
        try {
            User user = this.userRepository.createUser(CreateUser.builder().name(userResource.getDisplayName()).email(primaryEmail.getValue()).active(userResource.getActive()).externalId(userResource.getExternalId()).pictureUrl(pictureUrl).build());
            return Scim2Utils.asUserResource(user);
        }
        catch (BaseException e) {
            if (e.getErrorCode() == ErrorCode.ALREADY_EXISTS) {
                throw new Scim2RuntimeException((ScimException)new ResourceConflictException(e.getMessage()));
            }
            throw new Scim2RuntimeException((ScimException)new BadRequestException(e.getMessage()));
        }
    }

    @Get(value="/{id}")
    @Produces(value="application/scim+json")
    @StatusCode(value=200)
    @AuthorizeExpression(value="#principal != null")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public UserResource getUser(@Param(value="id") String id) {
        return Scim2Utils.asUserResource(this.userRepository.getUser(id));
    }

    @Put(value="/{id}")
    @Produces(value="application/scim+json")
    @StatusCode(value=200)
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public UserResource updateUser(@Param(value="id") String id, UserResource userResource) {
        UserResource user = Scim2Utils.asUserResource(this.userRepository.getUser(id));
        if (!id.equals(userResource.getId())) {
            throw new Scim2RuntimeException((ScimException)new ResourceConflictException("User id mismatch."));
        }
        UpdateUser updateUser = UpdateUser.builder().name(userResource.getDisplayName()).active(userResource.getActive()).externalId(userResource.getExternalId()).build();
        return Scim2Utils.asUserResource(this.userRepository.updateUser(id, updateUser));
    }

    @Delete(value="/{id}")
    @AuthorizeExpression(value="#authorizeAny(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteUser(@Param(value="id") String id) {
        User user = this.userRepository.getUser(id);
        this.authorizer.clearAuthorizationsForPrincipal(UUID.fromString(Objects.requireNonNull(user.getId())));
        this.userRepository.deleteUser(user.getId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    @Patch(value="/{id}")
    public HttpResponse patchUser(@Param(value="id") String id, PatchRequest patchRequest) {
        return patchRequest.getOperations().stream().filter(op -> op.getOpType() == PatchOpType.REPLACE && op.getPath() == null).findFirst().map(op -> this.handleUserUpdate(id, (PatchOperation)op)).orElse(HttpResponse.of((HttpStatus)HttpStatus.NOT_IMPLEMENTED));
    }

    private HttpResponse handleUserUpdate(String id, PatchOperation operation) {
        try {
            Boolean value = (Boolean)operation.getValues(Boolean.class).get(0);
            UpdateUser updateUser = UpdateUser.builder().active(value).build();
            this.userRepository.updateUser(id, updateUser);
            return HttpResponse.of((HttpStatus)HttpStatus.OK);
        }
        catch (JsonProcessingException | ScimException e) {
            return this.handleExceptionDuringPatch((Exception)e);
        }
    }

    private HttpResponse handleExceptionDuringPatch(Exception ex) {
        if (ex instanceof ScimException) {
            throw new Scim2RuntimeException((ScimException)((Object)ex));
        }
        throw new Scim2RuntimeException((ScimException)new ServerErrorException("Problem with patch operation", ex.getMessage(), (Throwable)ex));
    }

    private Filter parseFilter(String filter) {
        try {
            return Parser.parseFilter((String)filter);
        }
        catch (BadRequestException e) {
            throw new Scim2RuntimeException((ScimException)((Object)e));
        }
    }

    private boolean match(FilterEvaluator filterEvaluator, Filter userFilter, UserResource user) {
        try {
            return userFilter == null || (Boolean)userFilter.visit((FilterVisitor)filterEvaluator, (Object)user.asGenericScimResource().getObjectNode()) != false;
        }
        catch (ScimException e) {
            throw new Scim2RuntimeException(e);
        }
    }
}

