/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.auth.annotation.AuthorizeKeys;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateTable;
import io.unitycatalog.server.model.ListTablesResponse;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.TableInfo;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class TableService
extends AuthorizedService {
    private final TableRepository tableRepository;
    private final SchemaRepository schemaRepository;
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;

    public TableService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.tableRepository = repositories.getTableRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.catalogRepository = repositories.getCatalogRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    @Post(value="")
    @AuthorizeExpression(value="    (#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorize(#principal, #schema, OWNER)) ||\n    (#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAll(#principal, #schema, USE_SCHEMA, CREATE_TABLE))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createTable(@AuthorizeKeys(value={@AuthorizeKey(value=SecurableType.SCHEMA, key="schema_name"), @AuthorizeKey(value=SecurableType.CATALOG, key="catalog_name")}) CreateTable createTable) {
        assert (createTable != null);
        TableInfo tableInfo = this.tableRepository.createTable(createTable);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(tableInfo.getCatalogName() + "." + tableInfo.getSchemaName());
        this.initializeHierarchicalAuthorization(tableInfo.getTableId(), schemaInfo.getSchemaId());
        return HttpResponse.ofJson((Object)tableInfo);
    }

    @Get(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG) && #authorizeAny(#principal, #table, OWNER, SELECT, MODIFY))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getTable(@Param(value="full_name") @AuthorizeKey(value=SecurableType.TABLE) String fullName) {
        assert (fullName != null);
        TableInfo tableInfo = this.tableRepository.getTable(fullName);
        return HttpResponse.ofJson((Object)tableInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listTables(@Param(value="catalog_name") String catalogName, @Param(value="schema_name") String schemaName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken, @Param(value="omit_properties") Optional<Boolean> omitProperties, @Param(value="omit_columns") Optional<Boolean> omitColumns) {
        ListTablesResponse listTablesResponse = this.tableRepository.listTables(catalogName, schemaName, maxResults, pageToken, omitProperties.orElse(false), omitColumns.orElse(false));
        this.filterTables("#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG) && #authorizeAny(#principal, #table, OWNER, SELECT, MODIFY))\n", listTablesResponse.getTables());
        return HttpResponse.ofJson((Object)listTablesResponse);
    }

    @Delete(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #table, OWNER))\n")
    public HttpResponse deleteTable(@Param(value="full_name") @AuthorizeKey(value=SecurableType.TABLE) String fullName) {
        TableInfo tableInfo = this.tableRepository.getTable(fullName);
        this.tableRepository.deleteTable(fullName);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(tableInfo.getCatalogName() + "." + tableInfo.getSchemaName());
        this.removeHierarchicalAuthorizations(tableInfo.getTableId(), schemaInfo.getSchemaId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    public void filterTables(String expression, List<TableInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, ti -> {
            CatalogInfo catalogInfo = this.catalogRepository.getCatalog(ti.getCatalogName());
            SchemaInfo schemaInfo = this.schemaRepository.getSchema(ti.getCatalogName() + "." + ti.getSchemaName());
            return Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(catalogInfo.getId()), SecurableType.SCHEMA, UUID.fromString(schemaInfo.getSchemaId()), SecurableType.TABLE, UUID.fromString(ti.getTableId()));
        });
    }
}

