/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.decorator.KeyMapper;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.GenerateTemporaryModelVersionCredential;
import io.unitycatalog.server.model.ModelVersionInfo;
import io.unitycatalog.server.model.ModelVersionOperation;
import io.unitycatalog.server.model.ModelVersionStatus;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.persist.ModelRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.utils.RepositoryUtils;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import java.util.Map;
import java.util.Set;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class TemporaryModelVersionCredentialsService {
    private final ModelRepository modelRepository;
    private final UserRepository userRepository;
    private final UnityAccessEvaluator evaluator;
    private final CloudCredentialVendor cloudCredentialVendor;
    private final KeyMapper keyMapper;

    public TemporaryModelVersionCredentialsService(UnityCatalogAuthorizer authorizer, CloudCredentialVendor cloudCredentialVendor, Repositories repositories) {
        this.evaluator = new UnityAccessEvaluator(authorizer);
        this.cloudCredentialVendor = cloudCredentialVendor;
        this.keyMapper = new KeyMapper(repositories);
        this.modelRepository = repositories.getModelRepository();
        this.userRepository = repositories.getUserRepository();
    }

    @Post(value="")
    public HttpResponse generateTemporaryModelVersionCredentials(GenerateTemporaryModelVersionCredential generateTemporaryModelVersionCredentials) {
        this.authorizeForOperation(generateTemporaryModelVersionCredentials);
        long modelVersion = generateTemporaryModelVersionCredentials.getVersion();
        String catalogName = generateTemporaryModelVersionCredentials.getCatalogName();
        String schemaName = generateTemporaryModelVersionCredentials.getSchemaName();
        String modelName = generateTemporaryModelVersionCredentials.getModelName();
        String fullName = RepositoryUtils.getAssetFullName(catalogName, schemaName, modelName);
        ModelVersionInfo modelVersionInfo = this.modelRepository.getModelVersion(fullName, modelVersion);
        String storageLocation = modelVersionInfo.getStorageLocation();
        if (storageLocation.toLowerCase().startsWith("file")) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Cannot request credentials on a model version with a file based storage location: " + fullName + "/" + modelVersion);
        }
        ModelVersionOperation requestedOperation = generateTemporaryModelVersionCredentials.getOperation();
        if (modelVersionInfo.getStatus() == ModelVersionStatus.FAILED_REGISTRATION || modelVersionInfo.getStatus() == ModelVersionStatus.MODEL_VERSION_STATUS_UNKNOWN) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Cannot request credentials on a model version with status " + modelVersionInfo.getStatus().getValue() + ": " + fullName + "/" + modelVersion);
        }
        if (modelVersionInfo.getStatus() != ModelVersionStatus.PENDING_REGISTRATION && requestedOperation == ModelVersionOperation.READ_WRITE_MODEL_VERSION) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Cannot request read/write credentials on a model version that has been finalized: " + fullName + "/" + modelVersion);
        }
        return HttpResponse.ofJson((Object)this.cloudCredentialVendor.vendCredential(modelVersionInfo.getStorageLocation(), this.modelVersionOperationToPrivileges(requestedOperation)));
    }

    private Set<CredentialContext.Privilege> modelVersionOperationToPrivileges(ModelVersionOperation modelVersionOperation) {
        return switch (modelVersionOperation) {
            default -> throw new IncompatibleClassChangeError();
            case ModelVersionOperation.READ_MODEL_VERSION -> Set.of(CredentialContext.Privilege.SELECT);
            case ModelVersionOperation.READ_WRITE_MODEL_VERSION -> Set.of(CredentialContext.Privilege.SELECT, CredentialContext.Privilege.UPDATE);
            case ModelVersionOperation.UNKNOWN_MODEL_VERSION_OPERATION -> throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Unknown operation in the request: " + String.valueOf((Object)ModelVersionOperation.UNKNOWN_MODEL_VERSION_OPERATION));
        };
    }

    private void authorizeForOperation(GenerateTemporaryModelVersionCredential generateTemporaryModelVersionCredentials) {
        String readExpression = "#authorizeAny(#principal, #registered_model, OWNER, EXECUTE) &&\n#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) &&\n#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG)\n";
        String writeExpression = "#authorize(#principal, #registered_model, OWNER) &&\n#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) &&\n#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG)\n";
        String authorizeExpression = generateTemporaryModelVersionCredentials.getOperation() == ModelVersionOperation.READ_MODEL_VERSION ? readExpression : writeExpression;
        Map<SecurableType, Object> resourceKeys = this.keyMapper.mapResourceKeys(Map.of(SecurableType.METASTORE, "metastore", SecurableType.CATALOG, generateTemporaryModelVersionCredentials.getCatalogName(), SecurableType.SCHEMA, generateTemporaryModelVersionCredentials.getSchemaName(), SecurableType.REGISTERED_MODEL, generateTemporaryModelVersionCredentials.getModelName()));
        if (!this.evaluator.evaluate(this.userRepository.findPrincipalId(), authorizeExpression, resourceKeys)) {
            throw new BaseException(ErrorCode.PERMISSION_DENIED, "Access denied.");
        }
    }
}

