/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.GenerateTemporaryPathCredential;
import io.unitycatalog.server.model.PathOperation;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import java.util.Collections;
import java.util.Set;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class TemporaryPathCredentialsService {
    private final CloudCredentialVendor cloudCredentialVendor;

    public TemporaryPathCredentialsService(CloudCredentialVendor cloudCredentialVendor) {
        this.cloudCredentialVendor = cloudCredentialVendor;
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorize(#principal, #metastore, OWNER)")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse generateTemporaryPathCredential(GenerateTemporaryPathCredential generateTemporaryPathCredential) {
        return HttpResponse.ofJson((Object)this.cloudCredentialVendor.vendCredential(generateTemporaryPathCredential.getUrl(), this.pathOperationToPrivileges(generateTemporaryPathCredential.getOperation())));
    }

    private Set<CredentialContext.Privilege> pathOperationToPrivileges(PathOperation pathOperation) {
        return switch (pathOperation) {
            default -> throw new IncompatibleClassChangeError();
            case PathOperation.PATH_READ -> Set.of(CredentialContext.Privilege.SELECT);
            case PathOperation.PATH_READ_WRITE, PathOperation.PATH_CREATE_TABLE -> Set.of(CredentialContext.Privilege.SELECT, CredentialContext.Privilege.UPDATE);
            case PathOperation.UNKNOWN_PATH_OPERATION -> Collections.emptySet();
        };
    }
}

