/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.decorator.KeyMapper;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.GenerateTemporaryTableCredential;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.TableInfo;
import io.unitycatalog.server.model.TableOperation;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class TemporaryTableCredentialsService {
    private final TableRepository tableRepository;
    private final UserRepository userRepository;
    private final UnityAccessEvaluator evaluator;
    private final CloudCredentialVendor cloudCredentialVendor;
    private final KeyMapper keyMapper;

    public TemporaryTableCredentialsService(UnityCatalogAuthorizer authorizer, CloudCredentialVendor cloudCredentialVendor, Repositories repositories) {
        this.evaluator = new UnityAccessEvaluator(authorizer);
        this.cloudCredentialVendor = cloudCredentialVendor;
        this.keyMapper = new KeyMapper(repositories);
        this.tableRepository = repositories.getTableRepository();
        this.userRepository = repositories.getUserRepository();
    }

    @Post(value="")
    public HttpResponse generateTemporaryTableCredential(GenerateTemporaryTableCredential generateTemporaryTableCredential) {
        this.authorizeForOperation(generateTemporaryTableCredential);
        String tableId = generateTemporaryTableCredential.getTableId();
        TableInfo tableInfo = this.tableRepository.getTableById(tableId);
        return HttpResponse.ofJson((Object)this.cloudCredentialVendor.vendCredential(tableInfo.getStorageLocation(), this.tableOperationToPrivileges(generateTemporaryTableCredential.getOperation())));
    }

    private Set<CredentialContext.Privilege> tableOperationToPrivileges(TableOperation tableOperation) {
        return switch (tableOperation) {
            default -> throw new IncompatibleClassChangeError();
            case TableOperation.READ -> Set.of(CredentialContext.Privilege.SELECT);
            case TableOperation.READ_WRITE -> Set.of(CredentialContext.Privilege.SELECT, CredentialContext.Privilege.UPDATE);
            case TableOperation.UNKNOWN_TABLE_OPERATION -> Collections.emptySet();
        };
    }

    private void authorizeForOperation(GenerateTemporaryTableCredential generateTemporaryTableCredential) {
        String readExpression = "#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAny(#principal, #table, OWNER, SELECT)\n";
        String writeExpression = "#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) &&\n(#authorize(#principal, #table, OWNER) || #authorizeAll(#principal, #table, SELECT, MODIFY))\n";
        String authorizeExpression = generateTemporaryTableCredential.getOperation() == TableOperation.READ ? readExpression : writeExpression;
        Map<SecurableType, Object> resourceKeys = this.keyMapper.mapResourceKeys(Map.of(SecurableType.METASTORE, "metastore", SecurableType.TABLE, generateTemporaryTableCredential.getTableId()));
        if (!this.evaluator.evaluate(this.userRepository.findPrincipalId(), authorizeExpression, resourceKeys)) {
            throw new BaseException(ErrorCode.PERMISSION_DENIED, "Access denied.");
        }
    }
}

