/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.decorator.KeyMapper;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.GenerateTemporaryVolumeCredential;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.VolumeInfo;
import io.unitycatalog.server.model.VolumeOperation;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.VolumeRepository;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class TemporaryVolumeCredentialsService {
    private final VolumeRepository volumeRepository;
    private final UserRepository userRepository;
    private final UnityAccessEvaluator evaluator;
    private final CloudCredentialVendor cloudCredentialVendor;
    private final KeyMapper keyMapper;

    public TemporaryVolumeCredentialsService(UnityCatalogAuthorizer authorizer, CloudCredentialVendor cloudCredentialVendor, Repositories repositories) {
        this.evaluator = new UnityAccessEvaluator(authorizer);
        this.cloudCredentialVendor = cloudCredentialVendor;
        this.keyMapper = new KeyMapper(repositories);
        this.volumeRepository = repositories.getVolumeRepository();
        this.userRepository = repositories.getUserRepository();
    }

    @Post(value="")
    public HttpResponse generateTemporaryTableCredential(GenerateTemporaryVolumeCredential generateTemporaryVolumeCredential) {
        this.authorizeForOperation(generateTemporaryVolumeCredential);
        String volumeId = generateTemporaryVolumeCredential.getVolumeId();
        if (volumeId.isEmpty()) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Volume ID is required.");
        }
        VolumeInfo volumeInfo = this.volumeRepository.getVolumeById(volumeId);
        return HttpResponse.ofJson((Object)this.cloudCredentialVendor.vendCredential(volumeInfo.getStorageLocation(), this.volumeOperationToPrivileges(generateTemporaryVolumeCredential.getOperation())));
    }

    private Set<CredentialContext.Privilege> volumeOperationToPrivileges(VolumeOperation volumeOperation) {
        return switch (volumeOperation) {
            default -> throw new IncompatibleClassChangeError();
            case VolumeOperation.READ_VOLUME -> Set.of(CredentialContext.Privilege.SELECT);
            case VolumeOperation.WRITE_VOLUME -> Set.of(CredentialContext.Privilege.SELECT, CredentialContext.Privilege.UPDATE);
            case VolumeOperation.UNKNOWN_VOLUME_OPERATION -> Collections.emptySet();
        };
    }

    private void authorizeForOperation(GenerateTemporaryVolumeCredential generateTemporaryVolumeCredential) {
        String readExpression = "#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAny(#principal, #volume, OWNER, READ_VOLUME)\n";
        String writeExpression = "#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) &&\n#authorizeAny(#principal, #schema, OWNER, USE_SCHEMA) &&\n#authorize(#principal, #volume, OWNER)\n";
        String authorizeExpression = generateTemporaryVolumeCredential.getOperation() == VolumeOperation.READ_VOLUME ? readExpression : writeExpression;
        Map<SecurableType, Object> resourceKeys = this.keyMapper.mapResourceKeys(Map.of(SecurableType.METASTORE, "metastore", SecurableType.VOLUME, generateTemporaryVolumeCredential.getVolumeId()));
        if (!this.evaluator.evaluate(this.userRepository.findPrincipalId(), authorizeExpression, resourceKeys)) {
            throw new BaseException(ErrorCode.PERMISSION_DENIED, "Access denied.");
        }
    }
}

