/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.annotation.AuthorizeExpression;
import io.unitycatalog.server.auth.annotation.AuthorizeKey;
import io.unitycatalog.server.auth.annotation.AuthorizeKeys;
import io.unitycatalog.server.auth.decorator.UnityAccessEvaluator;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateVolumeRequestContent;
import io.unitycatalog.server.model.ListVolumesResponseContent;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.UpdateVolumeRequestContent;
import io.unitycatalog.server.model.VolumeInfo;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.persist.VolumeRepository;
import io.unitycatalog.server.service.AuthorizedService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

@ExceptionHandler(value=GlobalExceptionHandler.class)
public class VolumeService
extends AuthorizedService {
    private final VolumeRepository volumeRepository;
    private final SchemaRepository schemaRepository;
    private final CatalogRepository catalogRepository;
    private final MetastoreRepository metastoreRepository;
    private final UnityAccessEvaluator evaluator;

    public VolumeService(UnityCatalogAuthorizer authorizer, Repositories repositories) {
        super(authorizer, repositories.getUserRepository());
        this.volumeRepository = repositories.getVolumeRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.catalogRepository = repositories.getCatalogRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
        this.evaluator = new UnityAccessEvaluator(authorizer);
    }

    @Post(value="")
    @AuthorizeExpression(value="#authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA)\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse createVolume(@AuthorizeKeys(value={@AuthorizeKey(value=SecurableType.SCHEMA, key="schema_name"), @AuthorizeKey(value=SecurableType.CATALOG, key="catalog_name")}) CreateVolumeRequestContent createVolumeRequest) {
        VolumeInfo volumeInfo = this.volumeRepository.createVolume(createVolumeRequest);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(volumeInfo.getCatalogName() + "." + volumeInfo.getSchemaName());
        this.initializeHierarchicalAuthorization(volumeInfo.getVolumeId(), schemaInfo.getSchemaId());
        return HttpResponse.ofJson((Object)volumeInfo);
    }

    @Get(value="")
    @AuthorizeExpression(value="#defer")
    public HttpResponse listVolumes(@Param(value="catalog_name") String catalogName, @Param(value="schema_name") String schemaName, @Param(value="max_results") Optional<Integer> maxResults, @Param(value="page_token") Optional<String> pageToken, @Param(value="include_browse") Optional<Boolean> includeBrowse) {
        ListVolumesResponseContent listVolumesResponse = this.volumeRepository.listVolumes(catalogName, schemaName, maxResults, pageToken, includeBrowse);
        this.filterVolumes("#authorize(#principal, #metastore, OWNER) ||\n#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG) && #authorizeAny(#principal, #volume, OWNER, READ_VOLUME))\n", listVolumesResponse.getVolumes());
        return HttpResponse.ofJson((Object)listVolumesResponse);
    }

    @Get(value="/{full_name}")
    @AuthorizeExpression(value="  #authorize(#principal, #metastore, OWNER) ||\n  #authorize(#principal, #catalog, OWNER) ||\n  (#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n  (#authorize(#principal, #schema, USE_SCHEMA) && #authorize(#principal, #catalog, USE_CATALOG) && #authorizeAny(#principal, #volume, OWNER, READ_VOLUME))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse getVolume(@Param(value="full_name") @AuthorizeKey(value=SecurableType.VOLUME) String fullName, @Param(value="include_browse") Optional<Boolean> includeBrowse) {
        return HttpResponse.ofJson((Object)this.volumeRepository.getVolume(fullName));
    }

    @Patch(value="/{full_name}")
    @AuthorizeExpression(value="(#authorize(#principal, #volume, OWNER) && #authorizeAny(#principal, #catalog, OWNER, USE_CATALOG) && #authorizeAny(#principal, #schema, OWNER, USE_SCHEMA))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse updateVolume(@Param(value="full_name") @AuthorizeKey(value=SecurableType.VOLUME) String fullName, UpdateVolumeRequestContent updateVolumeRequest) {
        return HttpResponse.ofJson((Object)this.volumeRepository.updateVolume(fullName, updateVolumeRequest));
    }

    @Delete(value="/{full_name}")
    @AuthorizeExpression(value="#authorize(#principal, #catalog, OWNER) ||\n(#authorize(#principal, #schema, OWNER) && #authorize(#principal, #catalog, USE_CATALOG)) ||\n(#authorize(#principal, #volume, OWNER) && #authorize(#principal, #catalog, USE_CATALOG) && #authorize(#principal, #schema, USE_SCHEMA))\n")
    @AuthorizeKey(value=SecurableType.METASTORE)
    public HttpResponse deleteVolume(@Param(value="full_name") @AuthorizeKey(value=SecurableType.VOLUME) String fullName) {
        VolumeInfo volumeInfo = this.volumeRepository.getVolume(fullName);
        this.volumeRepository.deleteVolume(fullName);
        SchemaInfo schemaInfo = this.schemaRepository.getSchema(volumeInfo.getCatalogName() + "." + volumeInfo.getSchemaName());
        this.removeHierarchicalAuthorizations(volumeInfo.getVolumeId(), schemaInfo.getSchemaId());
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    public void filterVolumes(String expression, List<VolumeInfo> entries) {
        UUID principalId = this.userRepository.findPrincipalId();
        this.evaluator.filter(principalId, expression, entries, vi -> {
            CatalogInfo catalogInfo = this.catalogRepository.getCatalog(vi.getCatalogName());
            SchemaInfo schemaInfo = this.schemaRepository.getSchema(vi.getCatalogName() + "." + vi.getSchemaName());
            return Map.of(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId(), SecurableType.CATALOG, UUID.fromString(catalogInfo.getId()), SecurableType.SCHEMA, UUID.fromString(schemaInfo.getSchemaId()), SecurableType.VOLUME, UUID.fromString(vi.getVolumeId()));
        });
    }
}

