/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential;

import com.google.auth.oauth2.AccessToken;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.model.AwsCredentials;
import io.unitycatalog.server.model.AzureUserDelegationSAS;
import io.unitycatalog.server.model.GcpOauthToken;
import io.unitycatalog.server.model.TemporaryCredentials;
import io.unitycatalog.server.persist.utils.FileOperations;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.service.credential.aws.AwsCredentialVendor;
import io.unitycatalog.server.service.credential.azure.AzureCredential;
import io.unitycatalog.server.service.credential.azure.AzureCredentialVendor;
import io.unitycatalog.server.service.credential.gcp.GcpCredentialVendor;
import java.net.URI;
import java.util.Set;
import software.amazon.awssdk.services.sts.model.Credentials;

public class CloudCredentialVendor {
    private final AwsCredentialVendor awsCredentialVendor;
    private final AzureCredentialVendor azureCredentialVendor;
    private final GcpCredentialVendor gcpCredentialVendor;

    public CloudCredentialVendor(AwsCredentialVendor awsCredentialVendor, AzureCredentialVendor azureCredentialVendor, GcpCredentialVendor gcpCredentialVendor) {
        this.awsCredentialVendor = awsCredentialVendor;
        this.azureCredentialVendor = azureCredentialVendor;
        this.gcpCredentialVendor = gcpCredentialVendor;
    }

    public TemporaryCredentials vendCredential(String path, Set<CredentialContext.Privilege> privileges) {
        if (path == null || path.isEmpty()) {
            throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Storage location is null or empty.");
        }
        URI storageLocationUri = URI.create(path);
        CredentialContext credentialContext = CredentialContext.create(storageLocationUri, privileges);
        return this.vendCredential(credentialContext);
    }

    public TemporaryCredentials vendCredential(CredentialContext context) {
        String location = context.getLocations().get(0);
        FileOperations.assertValidLocation(location);
        String storageScheme = context.getStorageScheme();
        TemporaryCredentials temporaryCredentials = new TemporaryCredentials();
        switch (storageScheme) {
            case "abfs": 
            case "abfss": {
                AzureCredential azureCredential = this.vendAzureCredential(context);
                temporaryCredentials.azureUserDelegationSas(new AzureUserDelegationSAS().sasToken(azureCredential.getSasToken())).expirationTime(azureCredential.getExpirationTimeInEpochMillis());
                break;
            }
            case "gs": {
                AccessToken gcpToken = this.vendGcpToken(context);
                temporaryCredentials.gcpOauthToken(new GcpOauthToken().oauthToken(gcpToken.getTokenValue())).expirationTime(gcpToken.getExpirationTime().getTime());
                break;
            }
            case "s3": {
                Credentials awsSessionCredentials = this.vendAwsCredential(context);
                temporaryCredentials.awsTempCredentials(new AwsCredentials().accessKeyId(awsSessionCredentials.accessKeyId()).secretAccessKey(awsSessionCredentials.secretAccessKey()).sessionToken(awsSessionCredentials.sessionToken()));
            }
        }
        return temporaryCredentials;
    }

    public Credentials vendAwsCredential(CredentialContext context) {
        return this.awsCredentialVendor.vendAwsCredentials(context);
    }

    public AzureCredential vendAzureCredential(CredentialContext context) {
        return this.azureCredentialVendor.vendAzureCredential(context);
    }

    public AccessToken vendGcpToken(CredentialContext context) {
        return this.gcpCredentialVendor.vendGcpToken(context);
    }
}

