/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential;

import java.net.URI;
import java.util.List;
import java.util.Set;

public class CredentialContext {
    private String storageScheme;
    private String storageBase;
    private Set<Privilege> privileges;
    private List<String> locations;

    public static CredentialContext create(URI locationURI, Set<Privilege> privileges) {
        return CredentialContext.builder().privileges(privileges).storageScheme(locationURI.getScheme()).storageBase(locationURI.getScheme() + "://" + locationURI.getAuthority()).locations(List.of(locationURI.toString())).build();
    }

    CredentialContext(String storageScheme, String storageBase, Set<Privilege> privileges, List<String> locations) {
        this.storageScheme = storageScheme;
        this.storageBase = storageBase;
        this.privileges = privileges;
        this.locations = locations;
    }

    public static CredentialContextBuilder builder() {
        return new CredentialContextBuilder();
    }

    public String getStorageScheme() {
        return this.storageScheme;
    }

    public String getStorageBase() {
        return this.storageBase;
    }

    public Set<Privilege> getPrivileges() {
        return this.privileges;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public static class CredentialContextBuilder {
        private String storageScheme;
        private String storageBase;
        private Set<Privilege> privileges;
        private List<String> locations;

        CredentialContextBuilder() {
        }

        public CredentialContextBuilder storageScheme(String storageScheme) {
            this.storageScheme = storageScheme;
            return this;
        }

        public CredentialContextBuilder storageBase(String storageBase) {
            this.storageBase = storageBase;
            return this;
        }

        public CredentialContextBuilder privileges(Set<Privilege> privileges) {
            this.privileges = privileges;
            return this;
        }

        public CredentialContextBuilder locations(List<String> locations) {
            this.locations = locations;
            return this;
        }

        public CredentialContext build() {
            return new CredentialContext(this.storageScheme, this.storageBase, this.privileges, this.locations);
        }

        public String toString() {
            return "CredentialContext.CredentialContextBuilder(storageScheme=" + this.storageScheme + ", storageBase=" + this.storageBase + ", privileges=" + String.valueOf(this.privileges) + ", locations=" + String.valueOf(this.locations) + ")";
        }
    }

    public static enum Privilege {
        SELECT,
        UPDATE;

    }
}

