/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.aws;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.service.credential.aws.AwsPolicyGenerator;
import io.unitycatalog.server.service.credential.aws.S3StorageConfig;
import io.unitycatalog.server.utils.ServerProperties;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;

public class AwsCredentialVendor {
    private final Map<String, S3StorageConfig> s3Configurations;

    public AwsCredentialVendor(ServerProperties serverProperties) {
        this.s3Configurations = serverProperties.getS3Configurations();
    }

    public Credentials vendAwsCredentials(CredentialContext context) {
        S3StorageConfig s3StorageConfig = this.s3Configurations.get(context.getStorageBase());
        if (s3StorageConfig == null) {
            throw new BaseException(ErrorCode.FAILED_PRECONDITION, "S3 bucket configuration not found.");
        }
        if (s3StorageConfig.getSessionToken() != null && !s3StorageConfig.getSessionToken().isEmpty()) {
            return (Credentials)Credentials.builder().accessKeyId(s3StorageConfig.getAccessKey()).secretAccessKey(s3StorageConfig.getSecretKey()).sessionToken(s3StorageConfig.getSessionToken()).build();
        }
        StsClient stsClient = this.getStsClientForStorageConfig(s3StorageConfig);
        String roleSessionName = "uc-%s".formatted(UUID.randomUUID());
        String awsPolicy = AwsPolicyGenerator.generatePolicy(context.getPrivileges(), context.getLocations());
        return stsClient.assumeRole(r -> r.roleArn(s3StorageConfig.getAwsRoleArn()).policy(awsPolicy).roleSessionName(roleSessionName).durationSeconds(Integer.valueOf((int)Duration.ofHours(1L).toSeconds()))).credentials();
    }

    private StsClient getStsClientForStorageConfig(S3StorageConfig s3StorageConfig) {
        Object credentialsProvider = s3StorageConfig.getSecretKey() != null && !s3StorageConfig.getAccessKey().isEmpty() ? StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)s3StorageConfig.getAccessKey(), (String)s3StorageConfig.getSecretKey())) : DefaultCredentialsProvider.create();
        return (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.of((String)s3StorageConfig.getRegion()))).build();
    }
}

