/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.aws;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.unitycatalog.server.service.credential.CredentialContext;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.exceptions.NotAuthorizedException;

public class AwsPolicyGenerator {
    static final List<String> SELECT_ACTIONS = List.of("s3:GetO*");
    static final List<String> UPDATE_ACTIONS = List.of("s3:GetO*", "s3:PutO*", "s3:DeleteO*", "s3:*Multipart*");
    static final String POLICY_STATEMENT = "Version: 2012-10-17\nStatement: []\n";
    static final String BUCKET_STATEMENT = "Effect: Allow\nAction:\n  - s3:ListBucket\nResource: []\nCondition:\n  StringLike:\n    \"s3:prefix\": []\n";
    static final String OPERATION_STATEMENT = "Effect: Allow\nAction: []\nResource: []\n";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String generatePolicy(Set<CredentialContext.Privilege> privileges, List<String> locations) {
        JsonNode policyRoot = AwsPolicyGenerator.loadYaml(POLICY_STATEMENT);
        ArrayNode policyStatement = (ArrayNode)policyRoot.findPath("Statement");
        JsonNode operationsStatement = AwsPolicyGenerator.loadYaml(OPERATION_STATEMENT);
        policyStatement.add(operationsStatement);
        ArrayNode actions = (ArrayNode)operationsStatement.findPath("Action");
        if (privileges.contains((Object)CredentialContext.Privilege.UPDATE)) {
            UPDATE_ACTIONS.forEach(arg_0 -> ((ArrayNode)actions).add(arg_0));
        } else if (privileges.contains((Object)CredentialContext.Privilege.SELECT)) {
            SELECT_ACTIONS.forEach(arg_0 -> ((ArrayNode)actions).add(arg_0));
        } else {
            throw new NotAuthorizedException("Can't generate policy for unknown privileges '%s' for locations: '%s'".formatted(privileges, locations), new Object[0]);
        }
        AwsPolicyGenerator.getBucketToPathsMap(locations).forEach((bucketName, paths) -> {
            JsonNode listStatement = AwsPolicyGenerator.loadYaml(BUCKET_STATEMENT);
            policyStatement.add(listStatement);
            ArrayNode bucketResource = (ArrayNode)listStatement.findPath("Resource");
            ArrayNode operationsResource = (ArrayNode)operationsStatement.findPath("Resource");
            bucketResource.add("arn:aws:s3:::%s".formatted(bucketName));
            ArrayNode conditionalPrefixes = (ArrayNode)listStatement.findPath("s3:prefix");
            paths.forEach(path -> {
                String sanitizedPath = path.replaceAll("^/+", "");
                if (sanitizedPath.isEmpty()) {
                    conditionalPrefixes.add("*");
                    operationsResource.add("arn:aws:s3:::%s/*".formatted(bucketName));
                } else {
                    conditionalPrefixes.add(sanitizedPath);
                    conditionalPrefixes.add(sanitizedPath + "/");
                    conditionalPrefixes.add(sanitizedPath + "/*");
                    operationsResource.add("arn:aws:s3:::%s/%s/*".formatted(bucketName, sanitizedPath));
                    operationsResource.add("arn:aws:s3:::%s/%s".formatted(bucketName, sanitizedPath));
                }
            });
        });
        return JSON_MAPPER.writeValueAsString((Object)policyRoot);
    }

    private static Map<String, List<String>> getBucketToPathsMap(List<String> locations) {
        return locations.stream().map(URI::create).collect(Collectors.toMap(URI::getHost, uri -> new LinkedList<String>(List.of(uri.getPath())), (map, newPaths) -> {
            map.addAll(newPaths);
            return map;
        }));
    }

    private static JsonNode loadYaml(String s) {
        return YAML_MAPPER.readTree(s);
    }
}

