/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.aws;

public class S3StorageConfig {
    private final String bucketPath;
    private final String region;
    private final String awsRoleArn;
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;

    S3StorageConfig(String bucketPath, String region, String awsRoleArn, String accessKey, String secretKey, String sessionToken) {
        this.bucketPath = bucketPath;
        this.region = region;
        this.awsRoleArn = awsRoleArn;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
    }

    public static S3StorageConfigBuilder builder() {
        return new S3StorageConfigBuilder();
    }

    public String getBucketPath() {
        return this.bucketPath;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAwsRoleArn() {
        return this.awsRoleArn;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String toString() {
        return "S3StorageConfig(bucketPath=" + this.getBucketPath() + ", region=" + this.getRegion() + ", awsRoleArn=" + this.getAwsRoleArn() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", sessionToken=" + this.getSessionToken() + ")";
    }

    public static class S3StorageConfigBuilder {
        private String bucketPath;
        private String region;
        private String awsRoleArn;
        private String accessKey;
        private String secretKey;
        private String sessionToken;

        S3StorageConfigBuilder() {
        }

        public S3StorageConfigBuilder bucketPath(String bucketPath) {
            this.bucketPath = bucketPath;
            return this;
        }

        public S3StorageConfigBuilder region(String region) {
            this.region = region;
            return this;
        }

        public S3StorageConfigBuilder awsRoleArn(String awsRoleArn) {
            this.awsRoleArn = awsRoleArn;
            return this;
        }

        public S3StorageConfigBuilder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public S3StorageConfigBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public S3StorageConfigBuilder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public S3StorageConfig build() {
            return new S3StorageConfig(this.bucketPath, this.region, this.awsRoleArn, this.accessKey, this.secretKey, this.sessionToken);
        }

        public String toString() {
            return "S3StorageConfig.S3StorageConfigBuilder(bucketPath=" + this.bucketPath + ", region=" + this.region + ", awsRoleArn=" + this.awsRoleArn + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", sessionToken=" + this.sessionToken + ")";
        }
    }
}

