/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.azure;

public class ADLSStorageConfig {
    private String storageAccountName;
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private boolean testMode;

    ADLSStorageConfig(String storageAccountName, String tenantId, String clientId, String clientSecret, boolean testMode) {
        this.storageAccountName = storageAccountName;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.testMode = testMode;
    }

    public static ADLSStorageConfigBuilder builder() {
        return new ADLSStorageConfigBuilder();
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public static class ADLSStorageConfigBuilder {
        private String storageAccountName;
        private String tenantId;
        private String clientId;
        private String clientSecret;
        private boolean testMode;

        ADLSStorageConfigBuilder() {
        }

        public ADLSStorageConfigBuilder storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return this;
        }

        public ADLSStorageConfigBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ADLSStorageConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ADLSStorageConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public ADLSStorageConfigBuilder testMode(boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public ADLSStorageConfig build() {
            return new ADLSStorageConfig(this.storageAccountName, this.tenantId, this.clientId, this.clientSecret, this.testMode);
        }

        public String toString() {
            return "ADLSStorageConfig.ADLSStorageConfigBuilder(storageAccountName=" + this.storageAccountName + ", tenantId=" + this.tenantId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", testMode=" + this.testMode + ")";
        }
    }
}

