/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.azure;

public class AzureCredential {
    private String sasToken;
    private long expirationTimeInEpochMillis;

    AzureCredential(String sasToken, long expirationTimeInEpochMillis) {
        this.sasToken = sasToken;
        this.expirationTimeInEpochMillis = expirationTimeInEpochMillis;
    }

    public static AzureCredentialBuilder builder() {
        return new AzureCredentialBuilder();
    }

    public String getSasToken() {
        return this.sasToken;
    }

    public long getExpirationTimeInEpochMillis() {
        return this.expirationTimeInEpochMillis;
    }

    public static class AzureCredentialBuilder {
        private String sasToken;
        private long expirationTimeInEpochMillis;

        AzureCredentialBuilder() {
        }

        public AzureCredentialBuilder sasToken(String sasToken) {
            this.sasToken = sasToken;
            return this;
        }

        public AzureCredentialBuilder expirationTimeInEpochMillis(long expirationTimeInEpochMillis) {
            this.expirationTimeInEpochMillis = expirationTimeInEpochMillis;
            return this;
        }

        public AzureCredential build() {
            return new AzureCredential(this.sasToken, this.expirationTimeInEpochMillis);
        }

        public String toString() {
            return "AzureCredential.AzureCredentialBuilder(sasToken=" + this.sasToken + ", expirationTimeInEpochMillis=" + this.expirationTimeInEpochMillis + ")";
        }
    }
}

