/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.util.Context;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.file.datalake.DataLakeServiceAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.azure.storage.file.datalake.sas.PathSasPermission;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.service.credential.azure.ADLSLocationUtils;
import io.unitycatalog.server.service.credential.azure.ADLSStorageConfig;
import io.unitycatalog.server.service.credential.azure.AzureCredential;
import io.unitycatalog.server.utils.ServerProperties;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;

public class AzureCredentialVendor {
    private final Map<String, ADLSStorageConfig> adlsConfigurations;

    public AzureCredentialVendor(ServerProperties serverProperties) {
        this.adlsConfigurations = serverProperties.getAdlsConfigurations();
    }

    public AzureCredential vendAzureCredential(CredentialContext context) {
        DefaultAzureCredential tokenCredential;
        ADLSLocationUtils.ADLSLocationParts locationParts = ADLSLocationUtils.parseLocation(context.getStorageBase());
        ADLSStorageConfig config = this.adlsConfigurations.get(locationParts.accountName());
        if (config == null) {
            tokenCredential = new DefaultAzureCredentialBuilder().build();
        } else {
            if (config.isTestMode()) {
                return AzureCredential.builder().sasToken(String.format("%s/%s/%s", config.getTenantId(), config.getClientId(), config.getClientSecret())).expirationTimeInEpochMillis(253370790000000L).build();
            }
            tokenCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(config.getTenantId())).clientId(config.getClientId())).clientSecret(config.getClientSecret()).build();
        }
        DataLakeServiceAsyncClient serviceClient = new DataLakeServiceClientBuilder().httpClient(HttpClient.createDefault()).endpoint("https://" + locationParts.account()).credential((TokenCredential)tokenCredential).buildAsyncClient();
        OffsetDateTime start = OffsetDateTime.now();
        OffsetDateTime expiry = start.plusHours(1L);
        UserDelegationKey key = (UserDelegationKey)serviceClient.getUserDelegationKey(start, expiry).toFuture().join();
        PathSasPermission perms = this.resolvePrivileges(context.getPrivileges());
        DataLakeServiceSasSignatureValues sasSignatureValues = new DataLakeServiceSasSignatureValues(expiry, perms).setStartTime(start);
        String path = URI.create(context.getLocations().get(0)).getPath();
        path = path.replaceAll("^/+|/*$", "");
        String sasToken = new DataLakeSasImplUtil(sasSignatureValues, locationParts.container(), path, true).generateUserDelegationSas(key, locationParts.accountName(), Context.NONE);
        return AzureCredential.builder().sasToken(sasToken).expirationTimeInEpochMillis(expiry.toInstant().toEpochMilli()).build();
    }

    private PathSasPermission resolvePrivileges(Set<CredentialContext.Privilege> privileges) {
        PathSasPermission result = new PathSasPermission();
        if (privileges.contains((Object)CredentialContext.Privilege.UPDATE)) {
            result.setWritePermission(true);
            result.setDeletePermission(true);
        }
        if (privileges.contains((Object)CredentialContext.Privilege.SELECT)) {
            result.setReadPermission(true);
            result.setListPermission(true);
        }
        return result;
    }
}

