/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.credential.gcp;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.DownscopedCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.CharMatcher;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.utils.ServerProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Date;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Files;

public class GcpCredentialVendor {
    public static final List<String> INITIAL_SCOPES = List.of("https://www.googleapis.com/auth/cloud-platform");
    private final Map<String, String> gcsConfigurations;

    public GcpCredentialVendor(ServerProperties serverProperties) {
        this.gcsConfigurations = serverProperties.getGcsConfigurations();
    }

    public AccessToken vendGcpToken(CredentialContext credentialContext) {
        GoogleCredentials creds;
        String serviceAccountKeyJsonFilePath = this.gcsConfigurations.get(credentialContext.getStorageBase());
        if (serviceAccountKeyJsonFilePath != null && !serviceAccountKeyJsonFilePath.isEmpty()) {
            if (serviceAccountKeyJsonFilePath.startsWith("testing://")) {
                return AccessToken.newBuilder().setTokenValue(serviceAccountKeyJsonFilePath).setExpirationTime(Date.from(Instant.ofEpochMilli(253370790000000L))).build();
            }
            creds = ServiceAccountCredentials.fromStream((InputStream)Files.localInput((String)serviceAccountKeyJsonFilePath).newStream());
        } else {
            try {
                creds = GoogleCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "GCS credentials not found.", e);
            }
        }
        return this.downscopeGcpCreds(creds.createScoped(INITIAL_SCOPES), credentialContext).refreshAccessToken();
    }

    OAuth2Credentials downscopeGcpCreds(GoogleCredentials credentials, CredentialContext context) {
        CredentialAccessBoundary.Builder boundaryBuilder = CredentialAccessBoundary.newBuilder();
        List<String> roles = this.resolvePrivilegesToRoles(context.getPrivileges());
        context.getLocations().forEach(location -> {
            URI locationUri = URI.create(location);
            String path = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)locationUri.getPath());
            String resource = String.format("//storage.googleapis.com/projects/_/buckets/%s", locationUri.getHost());
            String resourceNameStartsWithExpr = String.format("resource.name.startsWith('projects/_/buckets/%s/objects/%s')", locationUri.getHost(), path);
            String objectListPrefixStartsWithExpr = String.format("api.getAttribute('storage.googleapis.com/objectListPrefix', '').startsWith('%s')", path);
            String combinedExpr = resourceNameStartsWithExpr + " || " + objectListPrefixStartsWithExpr;
            boundaryBuilder.addRule(CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailablePermissions(roles).setAvailabilityCondition(CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(combinedExpr).build()).setAvailableResource(resource).build());
        });
        return DownscopedCredentials.newBuilder().setSourceCredential(credentials).setCredentialAccessBoundary(boundaryBuilder.build()).build();
    }

    List<String> resolvePrivilegesToRoles(Set<CredentialContext.Privilege> privileges) {
        if (privileges.contains((Object)CredentialContext.Privilege.UPDATE)) {
            return List.of("inRole:roles/storage.objectAdmin");
        }
        if (privileges.contains((Object)CredentialContext.Privilege.SELECT)) {
            return List.of("inRole:roles/storage.objectViewer");
        }
        return List.of();
    }
}

