/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.iceberg;

import com.google.auth.oauth2.AccessToken;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.service.credential.aws.S3StorageConfig;
import io.unitycatalog.server.service.credential.azure.ADLSLocationUtils;
import io.unitycatalog.server.service.credential.azure.AzureCredential;
import io.unitycatalog.server.service.iceberg.SimpleLocalFileIO;
import io.unitycatalog.server.utils.ServerProperties;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.aws.s3.S3FileIO;
import org.apache.iceberg.azure.adlsv2.ADLSFileIO;
import org.apache.iceberg.gcp.gcs.GCSFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.SerializableSupplier;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;

public class FileIOFactory {
    private final CloudCredentialVendor cloudCredentialVendor;
    private final Map<String, S3StorageConfig> s3Configurations;

    public FileIOFactory(CloudCredentialVendor cloudCredentialVendor, ServerProperties serverProperties) {
        this.cloudCredentialVendor = cloudCredentialVendor;
        this.s3Configurations = serverProperties.getS3Configurations();
    }

    public FileIO getFileIO(URI tableLocationUri) {
        return switch (tableLocationUri.getScheme()) {
            case "abfs", "abfss" -> this.getADLSFileIO(tableLocationUri);
            case "gs" -> this.getGCSFileIO(tableLocationUri);
            case "s3" -> this.getS3FileIO(tableLocationUri);
            default -> new SimpleLocalFileIO();
        };
    }

    protected ADLSFileIO getADLSFileIO(URI tableLocationUri) {
        CredentialContext credentialContext = this.getCredentialContextFromTableLocation(tableLocationUri);
        AzureCredential credential = this.cloudCredentialVendor.vendAzureCredential(credentialContext);
        ADLSLocationUtils.ADLSLocationParts locationParts = ADLSLocationUtils.parseLocation(tableLocationUri.toString());
        Map<CallSite, String> properties = Map.of("adls.sas-token." + locationParts.account(), credential.getSasToken());
        ADLSFileIO result = new ADLSFileIO();
        result.initialize(properties);
        return result;
    }

    protected GCSFileIO getGCSFileIO(URI tableLocationUri) {
        CredentialContext credentialContext = this.getCredentialContextFromTableLocation(tableLocationUri);
        AccessToken gcpToken = this.cloudCredentialVendor.vendGcpToken(credentialContext);
        Map<String, String> properties = Map.of("gcs.oauth2.token", gcpToken.getTokenValue());
        GCSFileIO result = new GCSFileIO();
        result.initialize(properties);
        return result;
    }

    protected S3FileIO getS3FileIO(URI tableLocationUri) {
        CredentialContext context = this.getCredentialContextFromTableLocation(tableLocationUri);
        S3StorageConfig s3StorageConfig = this.s3Configurations.get(context.getStorageBase());
        S3FileIO s3FileIO = new S3FileIO((SerializableSupplier & Serializable)() -> this.getS3Client(this.getAwsCredentialsProvider(context), s3StorageConfig.getRegion()));
        s3FileIO.initialize(Map.of());
        return s3FileIO;
    }

    protected S3Client getS3Client(AwsCredentialsProvider awsCredentialsProvider, String region) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)region))).credentialsProvider(awsCredentialsProvider)).forcePathStyle(Boolean.valueOf(false))).build();
    }

    private AwsCredentialsProvider getAwsCredentialsProvider(CredentialContext context) {
        try {
            Credentials awsSessionCredentials = this.cloudCredentialVendor.vendAwsCredential(context);
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)awsSessionCredentials.accessKeyId(), (String)awsSessionCredentials.secretAccessKey(), (String)awsSessionCredentials.sessionToken()));
        }
        catch (BaseException e) {
            return DefaultCredentialsProvider.create();
        }
    }

    private CredentialContext getCredentialContextFromTableLocation(URI tableLocationUri) {
        return CredentialContext.create(tableLocationUri, Set.of(CredentialContext.Privilege.SELECT));
    }
}

