/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.service.iceberg;

import com.google.auth.oauth2.AccessToken;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.CredentialContext;
import io.unitycatalog.server.service.credential.aws.S3StorageConfig;
import io.unitycatalog.server.service.credential.azure.ADLSLocationUtils;
import io.unitycatalog.server.service.credential.azure.AzureCredential;
import io.unitycatalog.server.utils.ServerProperties;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.TableMetadata;
import software.amazon.awssdk.services.sts.model.Credentials;

public class TableConfigService {
    private final CloudCredentialVendor cloudCredentialVendor;
    private final Map<String, S3StorageConfig> s3Configurations;

    public TableConfigService(CloudCredentialVendor cloudCredentialVendor, ServerProperties serverProperties) {
        this.s3Configurations = serverProperties.getS3Configurations();
        this.cloudCredentialVendor = cloudCredentialVendor;
    }

    public Map<String, String> getTableConfig(TableMetadata tableMetadata) {
        URI locationURI = URI.create(tableMetadata.location());
        String scheme = locationURI.getScheme();
        CredentialContext context = CredentialContext.create(locationURI, Set.of(CredentialContext.Privilege.SELECT));
        return switch (scheme) {
            case "abfs", "abfss" -> this.getADLSConfig(context);
            case "gs" -> this.getGCSConfig(context);
            case "s3" -> this.getS3Config(context);
            default -> Map.of();
        };
    }

    private Map<String, String> getADLSConfig(CredentialContext context) {
        ADLSLocationUtils.ADLSLocationParts locationParts = ADLSLocationUtils.parseLocation(context.getStorageBase());
        AzureCredential azureCredential = this.cloudCredentialVendor.vendAzureCredential(context);
        return Map.of("adls.sas-token." + locationParts.account(), azureCredential.getSasToken());
    }

    private Map<String, String> getGCSConfig(CredentialContext context) {
        AccessToken token = this.cloudCredentialVendor.vendGcpToken(context);
        return Map.of("gcs.oauth2.token", token.getTokenValue(), "gcs.oauth2.token-expires-at", Long.toString(token.getExpirationTime().getTime()));
    }

    private Map<String, String> getS3Config(CredentialContext context) {
        S3StorageConfig s3StorageConfig = this.s3Configurations.get(context.getStorageBase());
        Credentials awsCredential = this.cloudCredentialVendor.vendAwsCredential(context);
        return Map.of("s3.access-key-id", awsCredential.accessKeyId(), "s3.secret-access-key", awsCredential.secretAccessKey(), "s3.session-token", awsCredential.sessionToken(), "client.region", s3StorageConfig.getRegion());
    }
}

