/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.utils;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.OAuthInvalidClientException;
import io.unitycatalog.server.exception.OAuthInvalidRequestException;
import io.unitycatalog.server.security.SecurityContext;
import java.net.URL;
import java.nio.file.Path;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksOperations {
    private final WebClient webClient = WebClient.builder().build();
    private static final ObjectMapper mapper = new ObjectMapper();
    private final SecurityContext securityContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(JwksOperations.class);

    public JwksOperations(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public JWTVerifier verifierForIssuerAndKey(String issuer, String keyId) {
        JwkProvider jwkProvider = this.loadJwkProvider(issuer);
        Jwk jwk = jwkProvider.get(keyId);
        if (!"RSA".equalsIgnoreCase(jwk.getPublicKey().getAlgorithm())) {
            throw new OAuthInvalidRequestException(ErrorCode.ABORTED, String.format("Invalid algorithm '%s' for issuer '%s'", jwk.getPublicKey().getAlgorithm(), issuer));
        }
        Algorithm algorithm = this.algorithmForJwk(jwk);
        return JWT.require((Algorithm)algorithm).withIssuer(issuer).build();
    }

    private Algorithm algorithmForJwk(Jwk jwk) {
        return switch (jwk.getAlgorithm()) {
            case "RS256" -> Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            case "RS384" -> Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            case "RS512" -> Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            default -> throw new OAuthInvalidClientException(ErrorCode.ABORTED, String.format("Unsupported algorithm: %s", jwk.getAlgorithm()));
        };
    }

    public JwkProvider loadJwkProvider(String issuer) {
        Object wellKnownConfigUrl;
        LOGGER.debug("Loading JwkProvider for issuer '{}'", issuer);
        if (((String)issuer).equals("internal")) {
            Path certsFile = this.securityContext.getCertsFile();
            return new JwkProviderBuilder(certsFile.toUri().toURL()).cached(false).build();
        }
        if (!((String)issuer).startsWith("https://") && !((String)issuer).startsWith("http://")) {
            issuer = "https://" + (String)issuer;
        }
        if (!((String)(wellKnownConfigUrl = issuer)).endsWith("/")) {
            wellKnownConfigUrl = (String)wellKnownConfigUrl + "/";
        }
        String path = (String)wellKnownConfigUrl + ".well-known/openid-configuration";
        LOGGER.debug("path: {}", (Object)path);
        String response = ((AggregatedHttpResponse)this.webClient.get(path).aggregate().join()).contentUtf8();
        Map configMap = (Map)mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (configMap == null || configMap.isEmpty()) {
            throw new OAuthInvalidRequestException(ErrorCode.ABORTED, "Could not get issuer configuration");
        }
        String configIssuer = (String)configMap.get("issuer");
        String configJwksUri = (String)configMap.get("jwks_uri");
        if (!configIssuer.equals(issuer)) {
            throw new OAuthInvalidRequestException(ErrorCode.ABORTED, "Issuer doesn't match configuration");
        }
        if (configJwksUri == null) {
            throw new OAuthInvalidRequestException(ErrorCode.ABORTED, "JWKS configuration missing");
        }
        return new JwkProviderBuilder(new URL(configJwksUri)).cached(false).build();
    }
}

