/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.utils;

import com.google.common.annotations.VisibleForTesting;
import io.unitycatalog.server.utils.VersionUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionParser {
    private int port = 8080;
    private final Options options = new Options();

    public OptionParser() {
        this.options.addOption(Option.builder((String)"p").longOpt("port").hasArg().desc("Port number to run the server on. Default is 8080.").type(Integer.class).build());
        this.options.addOption(Option.builder((String)"v").longOpt("version").hasArg(false).desc("Display the version of the Unity Catalog server").build());
        this.options.addOption("h", "help", false, "Print help message.");
    }

    private void printHelpAndExit(int code) {
        new HelpFormatter().printHelp("bin/start-uc-server", this.options);
        this.exit(code);
    }

    @VisibleForTesting
    protected void exit(int code) {
        System.exit(code);
    }

    public void parse(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            if (cmd.hasOption("h")) {
                this.printHelpAndExit(0);
            }
            if (cmd.hasOption("v")) {
                System.out.println(VersionUtils.VERSION);
                this.exit(0);
            }
            if (cmd.hasOption("p")) {
                this.setPort((Integer)cmd.getParsedOptionValue("p"));
            }
        }
        catch (ParseException e) {
            System.out.println();
            System.out.println("Parsing Failed. Reason: " + e.getMessage());
            System.out.println();
            this.printHelpAndExit(-1);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Options getOptions() {
        return this.options;
    }
}

