/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.utils;

import com.unboundid.scim2.common.types.Email;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.Photo;
import com.unboundid.scim2.common.types.UserResource;
import io.unitycatalog.control.model.User;
import java.net.URI;
import java.util.Calendar;
import java.util.List;

public class Scim2Utils {
    public static UserResource asUserResource(User user) {
        Meta meta = new Meta();
        Calendar created = Calendar.getInstance();
        if (user.getCreatedAt() != null) {
            created.setTimeInMillis(user.getCreatedAt());
        }
        meta.setCreated(created);
        Calendar lastModified = Calendar.getInstance();
        if (user.getUpdatedAt() != null) {
            lastModified.setTimeInMillis(user.getUpdatedAt());
        }
        meta.setLastModified(lastModified);
        meta.setResourceType("User");
        String pictureUrl = user.getPictureUrl();
        if (pictureUrl == null) {
            pictureUrl = "";
        }
        UserResource userResource = new UserResource();
        userResource.setUserName(user.getEmail()).setDisplayName(user.getName()).setEmails(List.of(new Email().setValue(user.getEmail()).setPrimary(Boolean.valueOf(true)))).setPhotos(List.of(new Photo().setValue(URI.create(pictureUrl))));
        userResource.setId(user.getId());
        userResource.setMeta(meta);
        userResource.setActive(Boolean.valueOf(user.getState() == User.StateEnum.ENABLED));
        userResource.setExternalId(user.getExternalId());
        return userResource;
    }
}

