/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.utils;

import io.unitycatalog.server.service.credential.aws.S3StorageConfig;
import io.unitycatalog.server.service.credential.azure.ADLSStorageConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerProperties.class);
    private final Properties properties;

    public ServerProperties() {
        this(new Properties());
    }

    public ServerProperties(String propertiesFile) {
        this(ServerProperties.readPropertiesFromFile(propertiesFile));
    }

    public ServerProperties(Properties properties) {
        this.properties = properties;
    }

    private static Properties readPropertiesFromFile(String propertiesFile) {
        Path path = Paths.get(propertiesFile, new String[0]);
        Properties propertiesFromFile = new Properties();
        if (path.toFile().exists()) {
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                propertiesFromFile.load(input);
                LOGGER.debug("Server properties loaded successfully: {}", (Object)path);
            }
            catch (IOException ex) {
                LOGGER.error("Exception during loading properties", (Throwable)ex);
            }
        }
        return propertiesFromFile;
    }

    public Map<String, S3StorageConfig> getS3Configurations() {
        HashMap<String, S3StorageConfig> s3BucketConfigMap = new HashMap<String, S3StorageConfig>();
        int i = 0;
        while (true) {
            String bucketPath = this.properties.getProperty("s3.bucketPath." + i);
            String region = this.properties.getProperty("s3.region." + i);
            String awsRoleArn = this.properties.getProperty("s3.awsRoleArn." + i);
            String accessKey = this.properties.getProperty("s3.accessKey." + i);
            String secretKey = this.properties.getProperty("s3.secretKey." + i);
            String sessionToken = this.properties.getProperty("s3.sessionToken." + i);
            if (!(bucketPath != null && region != null && awsRoleArn != null || accessKey != null && secretKey != null && sessionToken != null)) break;
            S3StorageConfig s3StorageConfig = S3StorageConfig.builder().bucketPath(bucketPath).region(region).awsRoleArn(awsRoleArn).accessKey(accessKey).secretKey(secretKey).sessionToken(sessionToken).build();
            s3BucketConfigMap.put(bucketPath, s3StorageConfig);
            ++i;
        }
        return s3BucketConfigMap;
    }

    public Map<String, String> getGcsConfigurations() {
        HashMap<String, String> gcsConfigMap = new HashMap<String, String>();
        int i = 0;
        while (true) {
            String bucketPath = this.properties.getProperty("gcs.bucketPath." + i);
            String jsonKeyFilePath = this.properties.getProperty("gcs.jsonKeyFilePath." + i);
            if (bucketPath == null || jsonKeyFilePath == null) break;
            gcsConfigMap.put(bucketPath, jsonKeyFilePath);
            ++i;
        }
        return gcsConfigMap;
    }

    public Map<String, ADLSStorageConfig> getAdlsConfigurations() {
        HashMap<String, ADLSStorageConfig> adlsConfigMap = new HashMap<String, ADLSStorageConfig>();
        int i = 0;
        while (true) {
            String storageAccountName = this.properties.getProperty("adls.storageAccountName." + i);
            String tenantId = this.properties.getProperty("adls.tenantId." + i);
            String clientId = this.properties.getProperty("adls.clientId." + i);
            String clientSecret = this.properties.getProperty("adls.clientSecret." + i);
            String testMode = this.properties.getProperty("adls.testMode." + i);
            if (storageAccountName == null || tenantId == null || clientId == null || clientSecret == null) break;
            adlsConfigMap.put(storageAccountName, ADLSStorageConfig.builder().storageAccountName(storageAccountName).tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).testMode(testMode != null && testMode.equalsIgnoreCase("true")).build());
            ++i;
        }
        return adlsConfigMap;
    }

    public String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        if (System.getenv().containsKey(key)) {
            return System.getenv(key);
        }
        return this.properties.getProperty(key);
    }

    public String get(Property property) {
        return this.getProperty(property.getKey());
    }

    public void set(Property property, String value) {
        this.properties.setProperty(property.getKey(), value);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public boolean isAuthorizationEnabled() {
        String authorization = this.getProperty("server.authorization", "disable");
        return authorization.equalsIgnoreCase("enable");
    }

    public static enum Property {
        MODEL_STORAGE_ROOT("storage-root.models");

        private final String key;

        private Property(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

