/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.spark;

import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.ApiException;
import io.unitycatalog.client.api.SchemasApi;
import io.unitycatalog.client.api.TablesApi;
import io.unitycatalog.client.api.TemporaryCredentialsApi;
import io.unitycatalog.client.model.ColumnInfo;
import io.unitycatalog.client.model.ColumnTypeName;
import io.unitycatalog.client.model.CreateSchema;
import io.unitycatalog.client.model.CreateTable;
import io.unitycatalog.client.model.DataSourceFormat;
import io.unitycatalog.client.model.GenerateTemporaryTableCredential;
import io.unitycatalog.client.model.ListTablesResponse;
import io.unitycatalog.client.model.SchemaInfo;
import io.unitycatalog.client.model.TableInfo;
import io.unitycatalog.client.model.TableOperation;
import io.unitycatalog.client.model.TableType;
import io.unitycatalog.client.model.TemporaryCredentials;
import io.unitycatalog.spark.UCSingleCatalog$;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\r\u001a\t\u0001B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")\u0011\n\u0001C\u0001\u0015\"1q\n\u0001Q!\nACa!\u0018\u0001!B\u0013q\u0006BB1\u0001A\u0003&!\rC\u0003f\u0001\u0011\u0005c\rC\u0003P\u0001\u0011\u0005C\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011\u0011\u0015\u0001\u0005B\u0005\u001d\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\tY\f\u0001C!\u0003{Cq!a3\u0001\t\u0003\niMA\u0004V\u0007B\u0013x\u000e_=\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u00031)h.\u001b;zG\u0006$\u0018\r\\8h\u0015\u0005q\u0012AA5p\u0007\u0001\u0019B\u0001A\u0011*qA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB(cU\u0016\u001cG\u000f\u0005\u0002+m5\t1F\u0003\u0002-[\u000591-\u0019;bY><'B\u0001\u00180\u0003%\u0019wN\u001c8fGR|'O\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005i\u0011$BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001eL!aN\u0016\u0003\u0019Q\u000b'\r\\3DCR\fGn\\4\u0011\u0005)J\u0014B\u0001\u001e,\u0005I\u0019V\u000f\u001d9peR\u001ch*Y7fgB\f7-Z:\u0002\u0013\u0005\u0004\u0018n\u00117jK:$\bCA\u001fA\u001b\u0005q$BA \u001c\u0003\u0019\u0019G.[3oi&\u0011\u0011I\u0010\u0002\n\u0003BL7\t\\5f]R\fq\u0003^3na>\u0014\u0018M]=De\u0016$WM\u001c;jC2\u001c\u0018\t]5\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019s\u0014aA1qS&\u0011\u0001*\u0012\u0002\u0018)\u0016l\u0007o\u001c:bef\u001c%/\u001a3f]RL\u0017\r\\:Ba&\fa\u0001P5oSRtDcA&N\u001dB\u0011A\nA\u0007\u00023!)1h\u0001a\u0001y!)!i\u0001a\u0001\u0007\u0006!a.Y7f!\t\t&L\u0004\u0002S1B\u00111KV\u0007\u0002)*\u0011QkH\u0001\u0007yI|w\u000e\u001e \u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033Z\u000b\u0011\u0002^1cY\u0016\u001c\u0018\t]5\u0011\u0005\u0011{\u0016B\u00011F\u0005%!\u0016M\u00197fg\u0006\u0003\u0018.\u0001\u0006tG\",W.Y:Ba&\u0004\"\u0001R2\n\u0005\u0011,%AC*dQ\u0016l\u0017m]!qS\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007\u001d\\G\u000e\u0005\u0002iS6\ta+\u0003\u0002k-\n!QK\\5u\u0011\u0015yu\u00011\u0001Q\u0011\u0015iw\u00011\u0001o\u0003\u001dy\u0007\u000f^5p]N\u0004\"a\u001c:\u000e\u0003AT!!]\u0018\u0002\tU$\u0018\u000e\\\u0005\u0003gB\u0014\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q)\u0005\u0001\u0016A\u00037jgR$\u0016M\u00197fgR\u0011q/ \t\u0004QbT\u0018BA=W\u0005\u0015\t%O]1z!\tQ30\u0003\u0002}W\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000byL\u0001\u0019A@\u0002\u00139\fW.Z:qC\u000e,\u0007c\u00015y!\u0006IAn\\1e)\u0006\u0014G.\u001a\u000b\u0005\u0003\u000b\tY\u0001E\u0002+\u0003\u000fI1!!\u0003,\u0005\u0015!\u0016M\u00197f\u0011\u0019\tiA\u0003a\u0001u\u0006)\u0011\u000eZ3oi\u0006Y1M]3bi\u0016$\u0016M\u00197f))\t)!a\u0005\u0002\u0016\u0005\u0015\u0012q\u0007\u0005\u0007\u0003\u001bY\u0001\u0019\u0001>\t\u000f\u0005]1\u00021\u0001\u0002\u001a\u000511o\u00195f[\u0006\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?y\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u0012\u0003;\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t9c\u0003a\u0001\u0003S\t!\u0002]1si&$\u0018n\u001c8t!\u0011A\u00070a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r.\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005U\u0012q\u0006\u0002\n)J\fgn\u001d4pe6Dq!!\u000f\f\u0001\u0004\tY$\u0001\u0006qe>\u0004XM\u001d;jKN\u0004b!!\u0010\u0002BA\u0003VBAA \u0015\t\tX%\u0003\u0003\u0002D\u0005}\"aA'ba\u000692m\u001c8wKJ$H)\u0019;bg>,(oY3G_Jl\u0017\r\u001e\u000b\u0005\u0003\u0013\n)\u0006\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyEP\u0001\u0006[>$W\r\\\u0005\u0005\u0003'\niE\u0001\tECR\f7k\\;sG\u00164uN]7bi\"1\u0011q\u000b\u0007A\u0002A\u000baAZ8s[\u0006$\u0018!G2p]Z,'\u000f\u001e#bi\u0006$\u0016\u0010]3U_RK\b/\u001a(b[\u0016$B!!\u0018\u0002dA!\u00111JA0\u0013\u0011\t\t'!\u0014\u0003\u001d\r{G.^7o)f\u0004XMT1nK\"9\u0011QM\u0007A\u0002\u0005\u001d\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005m\u0011\u0011N\u0005\u0005\u0003W\niB\u0001\u0005ECR\fG+\u001f9f\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\u0007\u0003\u000b\t\t(a\u001d\t\r\u00055a\u00021\u0001{\u0011\u001d\t)H\u0004a\u0001\u0003o\nqa\u00195b]\u001e,7\u000fE\u0003i\u0003s\ni(C\u0002\u0002|Y\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\rQ\u0013qP\u0005\u0004\u0003\u0003[#a\u0003+bE2,7\t[1oO\u0016\f\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004Q\u0006%\u0015bAAF-\n9!i\\8mK\u0006t\u0007BBA\u0007\u001f\u0001\u0007!0A\u0006sK:\fW.\u001a+bE2,G#B4\u0002\u0014\u0006]\u0005BBAK!\u0001\u0007!0\u0001\u0005pY\u0012LE-\u001a8u\u0011\u0019\tI\n\u0005a\u0001u\u0006Aa.Z<JI\u0016tG/A\u0010dQ\u0016\u001c7.\u00168tkB\u0004xN\u001d;fI:+7\u000f^3e\u001d\u0006lWm\u001d9bG\u0016$2aZAP\u0011\u0015q\u0018\u00031\u0001\u0000\u00039a\u0017n\u001d;OC6,7\u000f]1dKN$\"!!*\u0011\u0007!Dx\u0010\u0006\u0003\u0002&\u0006%\u0006\"\u0002@\u0014\u0001\u0004y\u0018!\u00067pC\u0012t\u0015-\\3ta\u0006\u001cW-T3uC\u0012\fG/\u0019\u000b\u0005\u0003w\ty\u000bC\u0003\u007f)\u0001\u0007q0A\bde\u0016\fG/\u001a(b[\u0016\u001c\b/Y2f)\u00159\u0017QWA\\\u0011\u0015qX\u00031\u0001\u0000\u0011\u001d\tI,\u0006a\u0001\u0003w\t\u0001\"\\3uC\u0012\fG/Y\u0001\u000fC2$XM\u001d(b[\u0016\u001c\b/Y2f)\u00159\u0017qXAa\u0011\u0015qh\u00031\u0001\u0000\u0011\u001d\t)H\u0006a\u0001\u0003\u0007\u0004R\u0001[A=\u0003\u000b\u00042AKAd\u0013\r\tIm\u000b\u0002\u0010\u001d\u0006lWm\u001d9bG\u0016\u001c\u0005.\u00198hK\u0006iAM]8q\u001d\u0006lWm\u001d9bG\u0016$b!a\"\u0002P\u0006E\u0007\"\u0002@\u0018\u0001\u0004y\bbBAj/\u0001\u0007\u0011qQ\u0001\bG\u0006\u001c8-\u00193f\u0001")
public class UCProxy
implements TableCatalog,
SupportsNamespaces {
    private final ApiClient apiClient;
    private final TemporaryCredentialsApi temporaryCredentialsApi;
    private String name;
    private TablesApi tablesApi;
    private SchemasApi schemasApi;

    public boolean namespaceExists(String[] x$1) {
        return super.namespaceExists(x$1);
    }

    public Set<TableCatalogCapability> capabilities() {
        return super.capabilities();
    }

    public Table loadTable(Identifier x$1, Set<TableWritePrivilege> x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public Table loadTable(Identifier x$1, String x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public Table loadTable(Identifier x$1, long x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public Table createTable(Identifier x$1, Column[] x$2, Transform[] x$3, Map<String, String> x$4) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return super.createTable(x$1, x$2, x$3, x$4);
    }

    public boolean useNullableQuerySchema() {
        return super.useNullableQuerySchema();
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.name = name;
        this.tablesApi = new TablesApi(this.apiClient);
        this.schemasApi = new SchemasApi(this.apiClient);
    }

    public String name() {
        Predef$.MODULE$.assert(this.name != null);
        return this.name;
    }

    public Identifier[] listTables(String[] namespace) {
        this.checkUnsupportedNestedNamespace(namespace);
        String catalogName = this.name;
        String schemaName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace));
        int maxResults = 0;
        Object pageToken = null;
        ListTablesResponse response = this.tablesApi.listTables(catalogName, schemaName, Predef$.MODULE$.int2Integer(maxResults), null);
        return (Identifier[])((IterableOnceOps)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(response.getTables()).toSeq().map((Function1 & Serializable)table -> Identifier.of((String[])namespace, (String)table.getName()))).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        TemporaryCredentials temporaryCredentials;
        TableInfo tableInfo;
        try {
            tableInfo = this.tablesApi.getTable(new StringBuilder(1).append(this.name).append(".").append(ident.toString()).toString());
        }
        catch (Throwable throwable) {
            ApiException apiException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ApiException && (apiException = (ApiException)throwable2).getCode() == 404) {
                throw new NoSuchTableException(ident);
            }
            throw throwable;
        }
        TableInfo t = tableInfo;
        TableIdentifier identifier = new TableIdentifier(t.getName(), (Option)new Some((Object)t.getSchemaName()), (Option)new Some((Object)t.getCatalogName()));
        ArrayBuffer partitionCols = ArrayBuffer$.MODULE$.empty();
        StructField[] fields = (StructField[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(t.getColumns()).asScala()).map((Function1 & Serializable)col -> {
            Option$.MODULE$.apply((Object)col.getPartitionIndex()).foreach((Function1 & Serializable)index -> (ArrayBuffer)partitionCols.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)col.getName()), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(index)))));
            return new StructField(col.getName(), DataType$.MODULE$.fromDDL(col.getTypeText()), Predef$.MODULE$.Boolean2boolean(col.getNullable()), StructField$.MODULE$.apply$default$4()).withComment(col.getComment());
        })).toArray(ClassTag$.MODULE$.apply(StructField.class));
        URI uri = CatalogUtils$.MODULE$.stringToURI(t.getStorageLocation());
        String tableId = t.getTableId();
        try {
            temporaryCredentials = this.temporaryCredentialsApi.generateTemporaryTableCredentials(new GenerateTemporaryTableCredential().tableId(tableId).operation(TableOperation.READ_WRITE));
        }
        catch (ApiException e) {
            temporaryCredentials = this.temporaryCredentialsApi.generateTemporaryTableCredentials(new GenerateTemporaryTableCredential().tableId(tableId).operation(TableOperation.READ));
        }
        TemporaryCredentials temporaryCredentials2 = temporaryCredentials;
        scala.collection.immutable.Map<String, String> extraSerdeProps = UCSingleCatalog$.MODULE$.generateCredentialProps(uri.getScheme(), temporaryCredentials2);
        TableIdentifier x$7 = identifier;
        TableType tableType = t.getTableType();
        TableType tableType2 = TableType.MANAGED;
        CatalogTableType x$8 = !(tableType != null ? !tableType.equals(tableType2) : tableType2 != null) ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        Some x$12 = new Some((Object)uri);
        scala.collection.immutable.Map x$22 = (scala.collection.immutable.Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(t.getProperties()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus(extraSerdeProps);
        Option x$3 = CatalogStorageFormat$.MODULE$.empty().copy$default$2();
        Option x$4 = CatalogStorageFormat$.MODULE$.empty().copy$default$3();
        Option x$5 = CatalogStorageFormat$.MODULE$.empty().copy$default$4();
        boolean x$6 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        CatalogStorageFormat x$9 = CatalogStorageFormat$.MODULE$.empty().copy((Option)x$12, x$3, x$4, x$5, x$6, x$22);
        StructType x$10 = new StructType(fields);
        Some x$11 = new Some((Object)t.getDataSourceFormat().getValue());
        long x$122 = Predef$.MODULE$.Long2long(t.getCreatedAt());
        boolean x$13 = false;
        scala.collection.immutable.Seq x$14 = ((IterableOnceOps)((StrictOptimizedIterableOps)partitionCols.sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$2 -> (String)x$2._1())).toSeq();
        Option x$15 = CatalogTable$.MODULE$.apply$default$7();
        String x$16 = CatalogTable$.MODULE$.apply$default$8();
        long x$17 = CatalogTable$.MODULE$.apply$default$10();
        String x$18 = CatalogTable$.MODULE$.apply$default$11();
        scala.collection.immutable.Map x$19 = CatalogTable$.MODULE$.apply$default$12();
        Option x$20 = CatalogTable$.MODULE$.apply$default$13();
        Option x$21 = CatalogTable$.MODULE$.apply$default$14();
        Option x$222 = CatalogTable$.MODULE$.apply$default$15();
        Option x$23 = CatalogTable$.MODULE$.apply$default$16();
        scala.collection.immutable.Seq x$24 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$25 = CatalogTable$.MODULE$.apply$default$19();
        scala.collection.immutable.Map x$26 = CatalogTable$.MODULE$.apply$default$20();
        Option x$27 = CatalogTable$.MODULE$.apply$default$21();
        CatalogTable sparkTable = new CatalogTable(x$7, x$8, x$9, x$10, (Option)x$11, x$14, x$15, x$16, x$122, x$17, x$18, x$19, x$20, x$21, x$222, x$23, x$24, false, x$25, x$26, x$27);
        return (Table)Class.forName("org.apache.spark.sql.connector.catalog.V1Table").getDeclaredConstructor(CatalogTable.class).newInstance(sparkTable);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        this.checkUnsupportedNestedNamespace(ident.namespace());
        Predef$.MODULE$.assert(properties.get("provider") != null);
        CreateTable createTable = new CreateTable();
        createTable.setName(ident.name());
        createTable.setSchemaName((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())));
        createTable.setCatalogName(this.name);
        boolean hasExternalClause = properties.containsKey("external");
        String storageLocation = properties.get("location");
        Predef$.MODULE$.assert(storageLocation != null, (Function0 & Serializable)() -> "location should either be user specified or system generated.");
        boolean isManagedLocation = Option$.MODULE$.apply((Object)properties.get("is_managed_location")).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equalsIgnoreCase("true")));
        if (isManagedLocation) {
            Predef$.MODULE$.assert(!hasExternalClause, (Function0 & Serializable)() -> "location is only generated for managed tables.");
            throw new ApiException("Unity Catalog does not support managed table.");
        }
        createTable.setTableType(TableType.EXTERNAL);
        createTable.setStorageLocation(storageLocation);
        scala.collection.immutable.Seq columns = (scala.collection.immutable.Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ColumnInfo column = new ColumnInfo();
                column.setName(field.name());
                if (field.getComment().isDefined()) {
                    column.setComment((String)field.getComment().get());
                }
                column.setNullable(Predef$.MODULE$.boolean2Boolean(field.nullable()));
                column.setTypeText(field.dataType().simpleString());
                column.setTypeName(this.convertDataTypeToTypeName(field.dataType()));
                column.setTypeJson(field.dataType().json());
                column.setPosition(Predef$.MODULE$.int2Integer(i));
                return column;
            }
            throw new MatchError((Object)tuple2);
        });
        createTable.setColumns(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)columns));
        String format = properties.get("provider");
        createTable.setDataSourceFormat(this.convertDatasourceFormat(format));
        this.tablesApi.createTable(createTable);
        return this.loadTable(ident);
    }

    private DataSourceFormat convertDatasourceFormat(String format) {
        String string = format.toUpperCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -75029036: {
                if (!"PARQUET".equals(string)) break;
                return DataSourceFormat.PARQUET;
            }
            case 67046: {
                if (!"CSV".equals(string)) break;
                return DataSourceFormat.CSV;
            }
            case 78528: {
                if (!"ORC".equals(string)) break;
                return DataSourceFormat.ORC;
            }
            case 2021682: {
                if (!"AVRO".equals(string)) break;
                return DataSourceFormat.AVRO;
            }
            case 2286824: {
                if (!"JSON".equals(string)) break;
                return DataSourceFormat.JSON;
            }
            case 2571565: {
                if (!"TEXT".equals(string)) break;
                return DataSourceFormat.TEXT;
            }
            case 64930712: {
                if (!"DELTA".equals(string)) break;
                return DataSourceFormat.DELTA;
            }
        }
        throw new ApiException(new StringBuilder(32).append("DataSourceFormat not supported: ").append(format).toString());
    }

    private ColumnTypeName convertDataTypeToTypeName(DataType dataType) {
        DataType dataType2 = dataType;
        if (StringType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.STRING;
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.BOOLEAN;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.SHORT;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.INT;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.LONG;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.FLOAT;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.DOUBLE;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.BYTE;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.BINARY;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.TIMESTAMP_NTZ;
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return ColumnTypeName.TIMESTAMP;
        }
        throw new ApiException(new StringBuilder(24).append("DataType not supported: ").append(dataType.simpleString()).toString());
    }

    public Table alterTable(Identifier ident, scala.collection.immutable.Seq<TableChange> changes) {
        throw new UnsupportedOperationException("Altering a table is not supported yet");
    }

    public boolean dropTable(Identifier ident) {
        this.checkUnsupportedNestedNamespace(ident.namespace());
        Object ret = this.tablesApi.deleteTable(new .colon.colon((Object)this.name, (List)new .colon.colon((Object)ident.namespace()[0], (List)new .colon.colon((Object)ident.name(), (List)Nil$.MODULE$))).mkString("."));
        return BoxesRunTime.equals((Object)ret, (Object)BoxesRunTime.boxToInteger((int)200));
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        throw new UnsupportedOperationException("Renaming a table is not supported yet");
    }

    private void checkUnsupportedNestedNamespace(String[] namespace) {
        if (namespace.length > 1) {
            throw new ApiException(new StringBuilder(38).append("Nested namespaces are not supported:  ").append(Predef$.MODULE$.wrapRefArray((Object[])namespace).mkString(".")).toString());
        }
    }

    public String[][] listNamespaces() {
        return (String[][])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.schemasApi.listSchemas(this.name, Predef$.MODULE$.int2Integer(0), null).getSchemas()).asScala()).map((Function1 & Serializable)schema -> (String[])((Object[])new String[]{schema.getName()}))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public String[][] listNamespaces(String[] namespace) {
        throw new UnsupportedOperationException("Multi-layer namespace is not supported in Unity Catalog");
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        SchemaInfo schemaInfo;
        this.checkUnsupportedNestedNamespace(namespace);
        try {
            schemaInfo = this.schemasApi.getSchema(new StringBuilder(1).append(this.name).append(".").append(namespace[0]).toString());
        }
        catch (Throwable throwable) {
            ApiException apiException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ApiException && (apiException = (ApiException)throwable2).getCode() == 404) {
                throw new NoSuchNamespaceException(namespace);
            }
            throw throwable;
        }
        SchemaInfo schema = schemaInfo;
        scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(schema.getProperties()).asScala()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append("properties:").append(k).toString()), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        metadata.update((Object)"name", (Object)schema.getName());
        metadata.update((Object)"catalog_name", (Object)schema.getCatalogName());
        metadata.update((Object)"comment", (Object)schema.getComment());
        metadata.update((Object)"full_name", (Object)schema.getFullName());
        metadata.update((Object)"created_at", (Object)(schema.getCreatedAt() != null ? schema.getCreatedAt().toString() : "null"));
        metadata.update((Object)"updated_at", (Object)(schema.getUpdatedAt() != null ? schema.getUpdatedAt().toString() : "null"));
        metadata.update((Object)"schema_id", (Object)schema.getSchemaId());
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(metadata).asJava();
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        this.checkUnsupportedNestedNamespace(namespace);
        CreateSchema createSchema = new CreateSchema();
        createSchema.setCatalogName(this.name);
        createSchema.setName((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)));
        createSchema.setProperties(metadata);
        this.schemasApi.createSchema(createSchema);
    }

    public void alterNamespace(String[] namespace, scala.collection.immutable.Seq<NamespaceChange> changes) {
        throw new UnsupportedOperationException("Renaming a namespace is not supported yet");
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        this.checkUnsupportedNestedNamespace(namespace);
        this.schemasApi.deleteSchema(new StringBuilder(1).append(this.name).append(".").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace))).toString(), Predef$.MODULE$.boolean2Boolean(cascade));
        return true;
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (scala.collection.immutable.Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (scala.collection.immutable.Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])changes));
    }

    public UCProxy(ApiClient apiClient, TemporaryCredentialsApi temporaryCredentialsApi) {
        this.apiClient = apiClient;
        this.temporaryCredentialsApi = temporaryCredentialsApi;
        this.name = null;
        this.tablesApi = null;
        this.schemasApi = null;
    }
}

