/*
 * Decompiled with CFR 0.152.
 */
package io.unmock.spring;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.util.StreamUtils;

public class UnmockHttpResponse
extends AbstractClientHttpResponse {
    @NotNull
    private final Map<String, List<String>> headers;
    @NotNull
    private final int statusCode;
    @NotNull
    private final InputStream responseStream;

    UnmockHttpResponse(int statusCode, Map<String, List<String>> headers, InputStream responseStream) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.responseStream = responseStream;
    }

    public int getRawStatusCode() throws IOException {
        return this.statusCode;
    }

    public String getStatusText() throws IOException {
        return "unimplemented";
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            headers.put(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    public InputStream getBody() throws IOException {
        return this.responseStream;
    }

    public void close() {
        try {
            if (this.responseStream == null) {
                this.getBody();
            }
            StreamUtils.drain((InputStream)this.responseStream);
            this.responseStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

