/*
 * Decompiled with CFR 0.152.
 */
package io.unmock.spring;

import io.unmock.core.UnmockOptions;
import io.unmock.okhttp.UnmockInterceptor;
import io.unmock.spring.UnmockHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.ResponseCreator;

public class UnmockResponseCreator
implements ResponseCreator {
    @NotNull
    private final OkHttpClient unmockClient;
    @NotNull
    private final UnmockInterceptor interceptor;

    public UnmockResponseCreator(UnmockOptions unmockOptions) throws IOException {
        this.interceptor = new UnmockInterceptor(unmockOptions);
        this.unmockClient = new OkHttpClient.Builder().addInterceptor((Interceptor)this.interceptor).build();
    }

    @NotNull
    public List<String> getStories() {
        return this.interceptor.getStories();
    }

    public ClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
        URI url = request.getURI();
        HttpHeaders headers = request.getHeaders();
        OutputStream body = request.getBody();
        String method = request.getMethodValue();
        Headers.Builder headersBuilder = new Headers.Builder();
        if (body != null && !(body instanceof ByteArrayOutputStream)) {
            throw new IOException("Unmock can only decode ByteArrayOutputStreams, got this instead: " + body);
        }
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)body;
        for (Map.Entry entry : headers.entrySet()) {
            headersBuilder = headersBuilder.add((String)entry.getKey(), Arrays.stream(((List)entry.getValue()).toArray(new String[0])).collect(Collectors.joining(",")));
        }
        MediaType contentType = headers.getContentType();
        Request okhttpRequest = new Request.Builder().url(url.toURL()).headers(headersBuilder.build()).method(method, contentType == null ? null : RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.get((String)contentType.toString()), (byte[])byteArrayOutputStream.toByteArray())).build();
        Response response = this.unmockClient.newCall(okhttpRequest).execute();
        return new UnmockHttpResponse(response.code(), response.headers().toMultimap(), response.body().byteStream());
    }
}

