package io.uok.spacex.cache.processor;

import static io.lettuce.core.internal.LettuceSets.newHashSet;
import static org.springframework.core.annotation.AnnotationUtils.findAnnotation;
import static org.springframework.util.ObjectUtils.isEmpty;

import io.uok.spacex.cache.SpacexRedisCacheManager;
import io.uok.spacex.cache.annotation.CacheDuration;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.util.ReflectionUtils;

public class CacheBeanPostProcessor implements BeanPostProcessor {

  @Resource(name = "cacheManager")
  private SpacexRedisCacheManager spacexRedisCacheManager;

  @Override
  public Object postProcessBeforeInitialization(Object bean, String beanName)
      throws BeansException {
    return bean;
  }

  @Override
  public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
    CacheDuration defaultCacheDuration = findAnnotation(bean.getClass(), CacheDuration.class);
    CacheConfig cacheConfig = findAnnotation(bean.getClass(), CacheConfig.class);
    ReflectionUtils.doWithMethods(bean.getClass(), method -> {
      CacheDuration cacheDuration = findAnnotation(method, CacheDuration.class);
      if (cacheDuration == null) {
        cacheDuration = defaultCacheDuration;
      }
      if (cacheDuration == null) {
        return;
      }
      Cacheable cacheable = findAnnotation(method, Cacheable.class);
      Set<String> cacheNames = findCacheNames(cacheConfig, cacheable);
      for (String cacheName : cacheNames) {
        spacexRedisCacheManager.addRedisCache(cacheName, cacheDuration.value());
      }
    }, method -> null != findAnnotation(method, Cacheable.class));
    return bean;
  }


  private Set<String> findCacheNames(CacheConfig cacheConfig, Cacheable cacheable) {
    return isEmpty(cacheable.value()) ?
        newHashSet(cacheConfig.cacheNames()) : newHashSet(cacheable.value());
  }

}

