/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.cache;

import io.uok.spacex.cache.SpacexRedisCacheManager;
import io.uok.spacex.cache.processor.CacheBeanPostProcessor;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConfigurationProperties(prefix="spacex.cache")
@EnableCaching
@ConditionalOnProperty(name={"spacex.cache.enable"}, havingValue="true", matchIfMissing=true)
public class CacheConfig
extends CachingConfigurerSupport {
    @Value(value="${spacex.cache.default-expiration:0}")
    private int defaultExpiration;
    @Value(value="${spacex.cache.namespace:${spring.application.name}}")
    private String namespace;
    @Resource
    private RedisConnectionFactory redisConnectionFactory;

    public KeyGenerator keyGenerator() {
        return (o, method, args) -> {
            StringBuilder keyBuilder = new StringBuilder();
            boolean isFirst = true;
            if (args != null) {
                for (Object arg : args) {
                    if (!isFirst) {
                        keyBuilder.append(",");
                    } else {
                        isFirst = false;
                    }
                    if (arg != null) {
                        keyBuilder.append(arg.toString());
                        continue;
                    }
                    keyBuilder.append("null");
                }
            }
            return keyBuilder.toString();
        };
    }

    @Bean
    public CacheManager cacheManager() {
        return new SpacexRedisCacheManager(this.redisConnectionFactory, this.namespace, this.defaultExpiration);
    }

    @Bean
    public CacheBeanPostProcessor cacheBeanPostProcessor() {
        return new CacheBeanPostProcessor();
    }
}

