/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.cache;

import com.google.common.collect.Maps;
import io.uok.spacex.redis.serializer.KryoRedisSerializer;
import java.time.Duration;
import java.util.Map;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

public class SpacexRedisCacheManager
extends RedisCacheManager {
    private String namespace;
    private Map<String, RedisCache> spacexRedisCacheMap = Maps.newConcurrentMap();

    public SpacexRedisCacheManager(RedisConnectionFactory redisConnectionFactory, String namespace, long defaultExpiration) {
        super(RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory), SpacexRedisCacheManager.newConfig(namespace, defaultExpiration));
        this.namespace = namespace;
    }

    protected static RedisCacheConfiguration newConfig(String namespace, long duration) {
        return RedisCacheConfiguration.defaultCacheConfig().entryTtl(duration == 0L ? Duration.ZERO : Duration.ofSeconds(duration)).computePrefixWith(name -> "$cache::" + namespace + "::" + name + "::").serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new KryoRedisSerializer()));
    }

    protected RedisCache getMissingCache(String name) {
        if (this.spacexRedisCacheMap.containsKey(name)) {
            return this.spacexRedisCacheMap.get(name);
        }
        return super.getMissingCache(name);
    }

    public void addRedisCache(String name, long expireSeconds) {
        this.spacexRedisCacheMap.put(name, this.createRedisCache(name, SpacexRedisCacheManager.newConfig(this.namespace, expireSeconds)));
    }
}

