/*
 * Decompiled with CFR 0.152.
 */
package io.uok.spacex.cache.processor;

import io.lettuce.core.internal.LettuceSets;
import io.uok.spacex.cache.SpacexRedisCacheManager;
import io.uok.spacex.cache.annotation.CacheDuration;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class CacheBeanPostProcessor
implements BeanPostProcessor {
    @Resource(name="cacheManager")
    private SpacexRedisCacheManager spacexRedisCacheManager;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        CacheDuration defaultCacheDuration = (CacheDuration)AnnotationUtils.findAnnotation(bean.getClass(), CacheDuration.class);
        CacheConfig cacheConfig = (CacheConfig)AnnotationUtils.findAnnotation(bean.getClass(), CacheConfig.class);
        ReflectionUtils.doWithMethods(bean.getClass(), method -> {
            CacheDuration cacheDuration = (CacheDuration)AnnotationUtils.findAnnotation((Method)method, CacheDuration.class);
            if (cacheDuration == null) {
                cacheDuration = defaultCacheDuration;
            }
            if (cacheDuration == null) {
                return;
            }
            Cacheable cacheable = (Cacheable)AnnotationUtils.findAnnotation((Method)method, Cacheable.class);
            Set<String> cacheNames = this.findCacheNames(cacheConfig, cacheable);
            for (String cacheName : cacheNames) {
                this.spacexRedisCacheManager.addRedisCache(cacheName, cacheDuration.value());
            }
        }, method -> null != AnnotationUtils.findAnnotation((Method)method, Cacheable.class));
        return bean;
    }

    private Set<String> findCacheNames(CacheConfig cacheConfig, Cacheable cacheable) {
        return ObjectUtils.isEmpty((Object[])cacheable.value()) ? LettuceSets.newHashSet((Object[])cacheConfig.cacheNames()) : LettuceSets.newHashSet((Object[])cacheable.value());
    }
}

