package io.uok.spacex.core;

import com.querydsl.jpa.impl.JPAQueryFactory;
import io.uok.spacex.core.dao.DictionaryDAO;
import io.uok.spacex.core.dao.DictionaryItemDAO;
import io.uok.spacex.core.domain.DictionaryDO;
import io.uok.spacex.core.domain.DictionaryItemDO;
import io.uok.spacex.core.service.DictionarySV;
import io.uok.spacex.core.service.impl.DictionarySVImpl;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;


@Configuration
@ConfigurationProperties(prefix = "spacex.core")
@ConditionalOnProperty(name = "spacex.core.enable", havingValue = "true", matchIfMissing = true)
@EntityScan("io.uok.spacex.core.domain")
public class CoreConfig {

  @PersistenceContext
  private EntityManager entityManager;

  @Bean
  public JPAQueryFactory jpaQueryFactory() {
    return new JPAQueryFactory(entityManager);
  }

  @Bean
  public SpringContextHolder springContextHolder() {
    return new SpringContextHolder();
  }

  @Bean
  public JpaRepositoryFactoryBean<DictionaryDAO, DictionaryDO, Long> dictionaryDAO() {
    return new JpaRepositoryFactoryBean(DictionaryDAO.class);
  }

  @Bean
  public JpaRepositoryFactoryBean<DictionaryItemDAO, DictionaryItemDO, Long> dictionaryItemDAO() {
    return new JpaRepositoryFactoryBean(DictionaryItemDAO.class);
  }

  @Bean
  public DictionarySV dictionarySV() {
    return new DictionarySVImpl();
  }


}
