package io.uok.spacex.core;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder implements ApplicationContextAware {

  private static ApplicationContext applicationContext;

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    SpringContextHolder.applicationContext = applicationContext;
  }

  /**
   * 获取存储在静态变量中的ApplicationContext
   */
  public static ApplicationContext getApplicationContext() {
    checkApplicationContext();
    return applicationContext;
  }

  /**
   * 从静态变量ApplicationContext中获取Bean，自动转型为所赋值对象的类型
   */
  public static <T> T getBean(String name) {
    checkApplicationContext();
    return (T) applicationContext.getBean(name);
  }

  public static <T> T getBean(Class<T> clazz) {
    checkApplicationContext();
    return (T) applicationContext.getBeansOfType(clazz);
  }

  /**
   * 清除ApplicationContext静态变量.
   */
  public static void cleanApplicationContext() {
    applicationContext = null;
  }

  /**
   * 检查是否获取到了ApplicationContext
   */
  private static void checkApplicationContext() {
    if (applicationContext == null) {
      throw new IllegalStateException(
          "applicationContext未注入,请在applicationContext.xml中定义SpringContextHolder");
    }
  }
}
