package io.uok.spacex.core.domain;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Data
@Entity
@Table(name = "sys_dict")
@SQLDelete(sql = "update sys_dict set deleted = 1 where id = ?")
@Where(clause = "deleted = 0")
@EntityListeners(AuditingEntityListener.class)
public class DictionaryDO {

  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;
  /**
   * 字典名称
   */
  @Size(min = 2, max = 32)
  private String name;

  /**
   * 字典编码
   */
  private String code;

  /**
   * 描述
   */
  private String description;

  private Boolean deleted;

  /**
   * 创建人
   */
  @CreatedBy
  private String createdBy;

  /**
   * 创建时间
   */
  @CreatedDate
  private Date createdTime;

  /**
   * 更新人
   */
  @LastModifiedBy
  private String updatedBy;

  /**
   * 更新时间
   */
  @LastModifiedDate
  private Date updatedTime;
}
