package io.uok.spacex.core.service;

import io.uok.spacex.core.domain.DictionaryDO;
import io.uok.spacex.core.domain.DictionaryItemDO;
import io.uok.spacex.core.dto.DictItemDTO;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


public interface DictionarySV {

  void add(DictionaryDO dictionary);

  void update(DictionaryDO dictionary);

  DictionaryDO get(String code);

  void delete(Long id);

  Page<DictionaryDO> find(String name, String code, String description, Pageable pageable);

  List<DictItemDTO> getItems(String code);

  void addItem(DictionaryItemDO dictionaryItem);

  void updateItem(DictionaryItemDO dictionaryItem);

  void deleteItem(Long itemId);

  List<DictionaryItemDO> findItems(Long id);
}
