package io.uok.spacex.validator.constraints;

import io.uok.spacex.validator.DictValidator;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;

@Documented
@Constraint(validatedBy = DictValidator.class)
@Target({ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@ReportAsSingleViolation
public @interface Dict {

  String name();

  String message() default "{数据字典取值不合法,请参考标准数据字典管理}";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};
}

